/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastools.api.shapes;

import io.github.applecommander.bastools.api.shapes.Shape;
import io.github.applecommander.bastools.api.shapes.VectorShape;
import io.github.applecommander.bastools.api.utils.Streams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ShapeTable {
    public final List<Shape> shapes = new ArrayList<Shape>();

    public static ShapeTable read(byte[] data) {
        Objects.requireNonNull(data);
        ShapeTable shapeTable = new ShapeTable();
        ByteBuffer buf = ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN);
        int count = Byte.toUnsignedInt(buf.get());
        buf.get();
        for (int i = 0; i < count; ++i) {
            short offset = buf.getShort();
            if (offset == 0) {
                shapeTable.shapes.add(new VectorShape());
                continue;
            }
            buf.mark();
            buf.position(offset);
            shapeTable.shapes.add(VectorShape.from(buf));
            buf.reset();
        }
        return shapeTable;
    }

    public static ShapeTable read(InputStream inputStream) throws IOException {
        Objects.requireNonNull(inputStream);
        return ShapeTable.read(Streams.toByteArray(inputStream));
    }

    public static ShapeTable read(File file) throws IOException {
        Objects.requireNonNull(file);
        return ShapeTable.read(file.toPath());
    }

    public static ShapeTable read(Path path) throws IOException {
        Objects.requireNonNull(path);
        return ShapeTable.read(Files.readAllBytes(path));
    }

    public int findPositionByLabel(String label) {
        for (int i = 0; i < this.shapes.size(); ++i) {
            if (!label.equalsIgnoreCase(this.shapes.get(i).getLabel())) continue;
            return i + 1;
        }
        throw new RuntimeException(String.format("Unable to locate shape with label of '%s'", label));
    }

    public void write(OutputStream outputStream) throws IOException {
        Objects.requireNonNull(outputStream);
        outputStream.write(this.shapes.size());
        outputStream.write(0);
        List data = this.shapes.stream().map(Shape::toVector).map(VectorShape::toBytes).collect(Collectors.toList());
        int offset = 2 + 2 * data.size();
        for (byte[] d : data) {
            outputStream.write(offset & 0xFF);
            outputStream.write(offset >> 8);
            offset += d.length;
        }
        for (byte[] d : data) {
            outputStream.write(d);
        }
    }

    public void write(File file) throws IOException {
        Objects.requireNonNull(file);
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            this.write(file);
        }
    }

    public void write(Path path) throws IOException {
        Objects.requireNonNull(path);
        this.write(path.toFile());
    }
}

