/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastools.api.shapes;

import io.github.applecommander.bastools.api.shapes.BitmapShape;
import io.github.applecommander.bastools.api.shapes.ExternalShapeImporter;
import io.github.applecommander.bastools.api.shapes.ShapeTable;
import io.github.applecommander.bastools.api.shapes.VectorShape;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Consumer;

public class ShapeGenerator {
    public static ShapeTable generate(Reader sourceReader) throws IOException {
        Objects.requireNonNull(sourceReader);
        ShapeTable st = new ShapeTable();
        LineNumberReader reader = new LineNumberReader(sourceReader);
        String line = reader.readLine();
        Consumer<String> shapeConsumer = null;
        while (line != null) {
            int comment = line.indexOf(59);
            if (comment > -1) {
                line = line.substring(0, comment);
            }
            line = line.trim();
            String[] parts = line.split("\\s+");
            String command = parts[0];
            String label = parts.length > 1 ? parts[1] : null;
            switch (command.toLowerCase()) {
                case ".short": {
                    VectorShape shortShape = new VectorShape(label);
                    st.shapes.add(shortShape);
                    shapeConsumer = shortShape::appendShortCommands;
                    break;
                }
                case ".long": {
                    VectorShape longShape = new VectorShape(label);
                    st.shapes.add(longShape);
                    shapeConsumer = longShape::appendLongCommands;
                    break;
                }
                case ".bitmap": {
                    BitmapShape bitmapShape = new BitmapShape(label);
                    st.shapes.add(bitmapShape);
                    shapeConsumer = bitmapShape::appendBitmapRow;
                    break;
                }
                case ".external": {
                    ExternalShapeImporter importer = new ExternalShapeImporter(st, label);
                    shapeConsumer = importer::process;
                    break;
                }
                default: {
                    if (line.length() == 0) break;
                    if (shapeConsumer != null) {
                        try {
                            shapeConsumer.accept(line);
                            break;
                        }
                        catch (Throwable t) {
                            String message = String.format("Error at line #%d - %s", reader.getLineNumber(), t.getMessage());
                            throw new IOException(message, t);
                        }
                    }
                    throw new IOException("Unexpected command: " + line);
                }
            }
            line = reader.readLine();
        }
        return st;
    }

    public static ShapeTable generate(InputStream inputStream) throws IOException {
        Objects.requireNonNull(inputStream);
        try (InputStreamReader reader = new InputStreamReader(inputStream);){
            ShapeTable shapeTable = ShapeGenerator.generate(reader);
            return shapeTable;
        }
    }

    public static ShapeTable generate(File file) throws IOException {
        Objects.requireNonNull(file);
        try (FileReader reader = new FileReader(file);){
            ShapeTable shapeTable = ShapeGenerator.generate(reader);
            return shapeTable;
        }
    }

    public static ShapeTable generate(Path path) throws IOException {
        Objects.requireNonNull(path);
        return ShapeGenerator.generate(path.toFile());
    }
}

