/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastools.api.shapes;

import io.github.applecommander.bastools.api.shapes.Shape;
import io.github.applecommander.bastools.api.shapes.ShapeTable;
import io.github.applecommander.bastools.api.shapes.exporters.ImageShapeExporter;
import io.github.applecommander.bastools.api.shapes.exporters.SourceShapeExporter;
import io.github.applecommander.bastools.api.shapes.exporters.TextShapeExporter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;

public interface ShapeExporter {
    public void export(Shape var1, OutputStream var2) throws IOException;

    default public void export(Shape shape, File file) throws IOException {
        Objects.requireNonNull(shape);
        Objects.requireNonNull(file);
        this.export(shape, file.toPath());
    }

    default public void export(Shape shape, Path path) throws IOException {
        Objects.requireNonNull(shape);
        Objects.requireNonNull(path);
        try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
            this.export(shape, outputStream);
        }
    }

    public void export(ShapeTable var1, OutputStream var2) throws IOException;

    default public void export(ShapeTable shapeTable, File file) throws IOException {
        Objects.requireNonNull(shapeTable);
        Objects.requireNonNull(file);
        this.export(shapeTable, file.toPath());
    }

    default public void export(ShapeTable shapeTable, Path path) throws IOException {
        Objects.requireNonNull(shapeTable);
        Objects.requireNonNull(path);
        try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
            this.export(shapeTable, outputStream);
        }
    }

    public static TextShapeExporter.Builder text() {
        return new TextShapeExporter.Builder();
    }

    public static ImageShapeExporter.Builder image() {
        return new ImageShapeExporter.Builder();
    }

    public static SourceShapeExporter.Builder source() {
        return new SourceShapeExporter.Builder();
    }
}

