/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastools.api.shapes;

import io.github.applecommander.bastools.api.shapes.Shape;
import io.github.applecommander.bastools.api.shapes.ShapeGenerator;
import io.github.applecommander.bastools.api.shapes.ShapeTable;
import io.github.applecommander.bastools.api.shapes.VectorShape;
import io.github.applecommander.bastools.api.utils.Converters;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.IntStream;

public class ExternalShapeImporter {
    private ShapeTable destination;
    private String firstShapeLabel;
    private Function<String, ShapeTable> importer = this::importShapeTableFromBinary;
    private IntStream intStream = null;

    public ExternalShapeImporter(ShapeTable destination, String firstShapeLabel) {
        this.destination = destination;
        this.firstShapeLabel = firstShapeLabel;
    }

    public void process(String line) {
        Objects.requireNonNull(line);
        String[] parts = line.split("=");
        if (parts.length != 2) {
            throw new RuntimeException(String.format(".external fields require an assignment for '%s'", line));
        }
        block5 : switch (parts[0].toLowerCase()) {
            case "type": {
                switch (parts[1].toLowerCase()) {
                    case "bin": {
                        this.importer = this::importShapeTableFromBinary;
                        break block5;
                    }
                    case "src": {
                        this.importer = this::importShapeTableFromSource;
                        break block5;
                    }
                }
                throw new RuntimeException(String.format("Unknown import type specified: '%s'", line));
            }
            case "shapes": {
                this.intStream = Converters.toIntStream(parts[1]);
                break;
            }
            case "import": {
                ShapeTable temp = this.importer.apply(parts[1]);
                this.intStream.map(n -> n - 1).mapToObj(temp.shapes::get).forEach(this::importShape);
                break;
            }
            default: {
                throw new RuntimeException(String.format("Unknown assignment '%s' for .external", line));
            }
        }
    }

    public ShapeTable importShapeTableFromBinary(String filename) {
        try {
            Objects.requireNonNull(this.intStream, ".external requires that 'shapes' is specified");
            return ShapeTable.read(Paths.get(filename, new String[0]));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public ShapeTable importShapeTableFromSource(String filename) {
        try {
            Objects.requireNonNull(this.intStream, ".external requires that 'shapes' is specified");
            return ShapeGenerator.generate(Paths.get(filename, new String[0]));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public void importShape(Shape shape) {
        if (this.firstShapeLabel != null) {
            VectorShape vshape = new VectorShape(this.firstShapeLabel);
            vshape.vectors.addAll(shape.toVector().vectors);
            this.destination.shapes.add(vshape);
            this.firstShapeLabel = null;
        } else {
            this.destination.shapes.add(shape);
        }
    }
}

