/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastools.api.shapes;

import io.github.applecommander.bastools.api.shapes.Shape;
import io.github.applecommander.bastools.api.shapes.VectorCommand;
import io.github.applecommander.bastools.api.shapes.VectorShape;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class BitmapShape
implements Shape {
    public final String label;
    public final List<List<Boolean>> grid = new ArrayList<List<Boolean>>();
    public final Point origin = new Point();

    public BitmapShape() {
        this(0, 0, null);
    }

    public BitmapShape(String label) {
        this(0, 0, label);
    }

    public BitmapShape(int height, int width) {
        this(height, width, null);
    }

    public BitmapShape(int height, int width, String label) {
        this.label = label;
        while (this.grid.size() < height) {
            this.grid.add(this.newRow(width));
        }
    }

    private List<Boolean> newRow(int width) {
        ArrayList<Boolean> row = new ArrayList<Boolean>();
        while (row.size() < width) {
            row.add(Boolean.FALSE);
        }
        return row;
    }

    public void insertColumn() {
        ++this.origin.x;
        for (List<Boolean> row : this.grid) {
            row.add(0, Boolean.FALSE);
        }
    }

    public void addColumn() {
        for (List<Boolean> row : this.grid) {
            row.add(Boolean.FALSE);
        }
    }

    public void insertRow() {
        ++this.origin.y;
        this.grid.add(0, this.newRow(this.getWidth()));
    }

    public void addRow() {
        this.grid.add(this.newRow(this.getWidth()));
    }

    public void appendBitmapRow(String line) {
        line = line.trim();
        ArrayList<Boolean> row = new ArrayList<Boolean>();
        Runnable setOrigin = () -> {
            this.origin.x = row.size();
            this.origin.y = this.grid.size();
        };
        block6: for (char pixel : line.toCharArray()) {
            switch (Character.toLowerCase(pixel)) {
                case '+': {
                    setOrigin.run();
                }
                case '.': {
                    row.add(Boolean.FALSE);
                    continue block6;
                }
                case '*': {
                    setOrigin.run();
                }
                case 'x': {
                    row.add(Boolean.TRUE);
                    continue block6;
                }
                default: {
                    throw new RuntimeException("Unexpected bitmap pixel type: " + pixel);
                }
            }
        }
        this.grid.add(row);
    }

    public int getHeight() {
        return this.grid.size();
    }

    public int getWidth() {
        return this.grid.isEmpty() ? 0 : this.grid.get(0).size();
    }

    public void plot(int x, int y) {
        this.plot(x, y, Boolean.TRUE);
    }

    public void plot(int x, int y, Boolean pixel) {
        if (x < 0 || x >= this.getWidth() || y < 0 || y >= this.getHeight()) {
            return;
        }
        this.grid.get(y).set(x, pixel);
    }

    public Boolean get(int x, int y) {
        if (x < 0 || x >= this.getWidth() || y < 0 || y >= this.getHeight()) {
            return Boolean.FALSE;
        }
        return this.grid.get(y).get(x);
    }

    public Boolean get(Point point) {
        return this.get(point.x, point.y);
    }

    @Override
    public boolean isEmpty() {
        boolean hasData = false;
        for (List<Boolean> row : this.grid) {
            for (Boolean plot : row) {
                hasData |= plot.booleanValue();
            }
        }
        return !hasData;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public BitmapShape toBitmap() {
        return this;
    }

    @Override
    public VectorShape toVector() {
        List<Supplier> scans = Arrays.asList(new SweepVectorization(this, VectorCommand.MOVE_RIGHT, VectorCommand.MOVE_UP), new SweepVectorization(this, VectorCommand.MOVE_RIGHT, VectorCommand.MOVE_DOWN), new SweepVectorization(this, VectorCommand.MOVE_LEFT, VectorCommand.MOVE_UP), new SweepVectorization(this, VectorCommand.MOVE_LEFT, VectorCommand.MOVE_DOWN), new SweepVectorization(this, VectorCommand.MOVE_DOWN, VectorCommand.MOVE_RIGHT), new SweepVectorization(this, VectorCommand.MOVE_DOWN, VectorCommand.MOVE_LEFT), new SweepVectorization(this, VectorCommand.MOVE_UP, VectorCommand.MOVE_RIGHT), new SweepVectorization(this, VectorCommand.MOVE_UP, VectorCommand.MOVE_LEFT), new EuclidianDistanceVectorization(this));
        int byteLength = Integer.MAX_VALUE;
        VectorShape vshape = null;
        for (Supplier scan : scans) {
            VectorShape candidate = (VectorShape)scan.get();
            int length = candidate.toBytes().length;
            if (vshape != null && byteLength < length) continue;
            vshape = candidate;
            byteLength = length;
        }
        return vshape;
    }

    public static class EuclidianDistanceVectorization
    implements Supplier<VectorShape> {
        private List<Point> points;
        private BitmapShape bitmapShape;
        private VectorShape vshape;

        public EuclidianDistanceVectorization(BitmapShape bitmapShape) {
            this.bitmapShape = bitmapShape;
            this.points = new ArrayList<Point>();
            this.vshape = new VectorShape();
            for (int y = 0; y < bitmapShape.getHeight(); ++y) {
                for (int x = 0; x < bitmapShape.getWidth(); ++x) {
                    if (!bitmapShape.get(x, y).booleanValue()) continue;
                    this.points.add(new Point(x, y));
                }
            }
        }

        @Override
        public VectorShape get() {
            Point point = new Point(this.bitmapShape.origin);
            boolean plotFirst = false;
            while (!this.points.isEmpty()) {
                Point target = null;
                double distance = Double.MAX_VALUE;
                for (Point candidate : this.points) {
                    double candidateDistance = point.distance(candidate);
                    if (!(distance >= candidateDistance)) continue;
                    distance = candidateDistance;
                    target = candidate;
                }
                this.moveTo(plotFirst, point, target);
                this.points.remove(target);
                point = target;
                plotFirst = true;
            }
            this.vshape.plotUp();
            return this.vshape;
        }

        public void moveTo(boolean plotFirst, Point origin, Point target) {
            VectorCommand yvector;
            if (origin.equals(target)) {
                return;
            }
            VectorCommand xvector = origin.x < target.x ? VectorCommand.MOVE_RIGHT : VectorCommand.MOVE_LEFT;
            VectorCommand vectorCommand = yvector = origin.y < target.y ? VectorCommand.MOVE_DOWN : VectorCommand.MOVE_UP;
            if (plotFirst) {
                xvector = xvector.plot();
                yvector = yvector.plot();
            }
            Point point = new Point(origin);
            int xdist = Math.abs(point.x - target.x);
            int ydist = Math.abs(point.y - target.y);
            while (!point.equals(target)) {
                if (xdist > ydist) {
                    xdist = Math.abs(point.x - target.x);
                    ++ydist;
                    if (point.x == target.x) continue;
                    point.translate(xvector.xmove, xvector.ymove);
                    this.vshape.append(xvector);
                    xvector = xvector.move();
                    yvector = yvector.move();
                    continue;
                }
                ++xdist;
                ydist = Math.abs(point.y - target.y);
                if (point.y == target.y) continue;
                point.translate(yvector.xmove, yvector.ymove);
                this.vshape.append(yvector);
                xvector = xvector.move();
                yvector = yvector.move();
            }
        }
    }

    public static class SweepVectorization
    implements Supplier<VectorShape> {
        private VectorCommand[] toOrigin;
        private VectorCommand movement;
        private VectorCommand next;
        private Point point;
        private BitmapShape bitmapShape;
        private VectorShape vectorShape;
        private int width;
        private int height;

        public SweepVectorization(BitmapShape bitmapShape, VectorCommand initialMovement, VectorCommand next) {
            Objects.requireNonNull(bitmapShape);
            Objects.requireNonNull(initialMovement);
            Objects.requireNonNull(next);
            if (initialMovement.horizontal == next.horizontal || initialMovement.vertical == next.vertical) {
                throw new IllegalArgumentException("One vector must be horizontal and the other vector must be vertical");
            }
            this.toOrigin = new VectorCommand[]{next.opposite(), initialMovement.opposite()};
            this.movement = initialMovement;
            this.next = next;
            this.bitmapShape = bitmapShape;
            this.width = bitmapShape.getWidth();
            this.height = bitmapShape.getHeight();
            this.point = new Point(bitmapShape.origin);
            this.vectorShape = new VectorShape();
        }

        @Override
        public VectorShape get() {
            this.findStartPosition();
            while (!this.onOrAtEdge(this.next)) {
                this.scanRow();
                this.plotOrMove(this.next);
                this.movement = this.movement.opposite();
                this.point.translate(this.next.xmove, this.next.ymove);
            }
            return this.vectorShape;
        }

        public void findStartPosition() {
            for (VectorCommand vector : this.toOrigin) {
                while (!this.onOrAtEdge(vector)) {
                    this.vectorShape.vectors.add(vector);
                    this.point.translate(vector.xmove, vector.ymove);
                }
            }
        }

        public void scanRow() {
            while (!this.onOrAtEdge(this.movement)) {
                this.plotOrMove(this.movement);
                this.point.translate(this.movement.xmove, this.movement.ymove);
            }
        }

        public void plotOrMove(VectorCommand vector) {
            if (this.bitmapShape.get(this.point).booleanValue()) {
                this.vectorShape.appendShortCommand(Character.toUpperCase(vector.shortCommand));
            } else {
                this.vectorShape.appendShortCommand(Character.toLowerCase(vector.shortCommand));
            }
        }

        public boolean onOrAtEdge(VectorCommand vector) {
            switch (vector) {
                case MOVE_DOWN: 
                case PLOT_DOWN: {
                    return this.point.y >= this.height;
                }
                case MOVE_UP: 
                case PLOT_UP: {
                    return this.point.y < 0;
                }
                case MOVE_LEFT: 
                case PLOT_LEFT: {
                    return this.point.x < 0;
                }
                case MOVE_RIGHT: 
                case PLOT_RIGHT: {
                    return this.point.x >= this.width;
                }
            }
            throw new RuntimeException("Unexpected vector: " + vector);
        }
    }
}

