/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastools.api.optimizations;

import io.github.applecommander.bastools.api.Configuration;
import io.github.applecommander.bastools.api.Visitors;
import io.github.applecommander.bastools.api.model.Program;
import io.github.applecommander.bastools.api.model.Statement;
import io.github.applecommander.bastools.api.model.Token;
import io.github.applecommander.bastools.api.optimizations.BaseVisitor;
import io.github.applecommander.bastools.api.utils.VariableNameGenerator;
import io.github.applecommander.bastools.api.visitors.VariableCollectorVisitor;
import java.util.Optional;
import java.util.Set;

public class ShortenVariableNames
extends BaseVisitor {
    private Configuration config;
    private VariableNameGenerator variableGenerator = new VariableNameGenerator();

    public ShortenVariableNames(Configuration config) {
        this.config = config;
    }

    @Override
    public Program visit(Program program) {
        VariableCollectorVisitor collector = Visitors.variableCollectorVisitor();
        program.accept(collector);
        Set<String> existingVariables = collector.getVariableNames();
        for (String originalName : existingVariables) {
            Object newName = originalName;
            if (((String)newName).replaceAll("[^\\p{Alnum}]", "").length() > 2) {
                String varType = ((String)newName).replaceAll("[\\p{Alnum}]", "");
                do {
                    newName = (String)((Optional)this.variableGenerator.get()).orElseThrow(() -> new RuntimeException("Ran out of variable names to assign"));
                } while (existingVariables.contains(newName = (String)newName + varType));
                this.config.debugStream.printf("Replacing '%s' with '%s'\n", originalName, newName);
            }
            this.config.variableReplacements.put(originalName, (String)newName);
        }
        return super.visit(program);
    }

    @Override
    public Statement visit(Statement statement) {
        if (statement.tokens.get((int)0).type == Token.Type.DIRECTIVE) {
            return statement;
        }
        return super.visit(statement);
    }

    @Override
    public Token visit(Token token) {
        if (token.type == Token.Type.IDENT) {
            return Token.ident(token.line, this.config.variableReplacements.get(token.text));
        }
        return super.visit(token);
    }
}

