/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastools.api.optimizations;

import io.github.applecommander.bastools.api.Configuration;
import io.github.applecommander.bastools.api.Visitors;
import io.github.applecommander.bastools.api.model.ApplesoftKeyword;
import io.github.applecommander.bastools.api.model.Line;
import io.github.applecommander.bastools.api.model.Program;
import io.github.applecommander.bastools.api.model.Statement;
import io.github.applecommander.bastools.api.model.Token;
import io.github.applecommander.bastools.api.optimizations.BaseVisitor;
import io.github.applecommander.bastools.api.utils.VariableNameGenerator;
import io.github.applecommander.bastools.api.visitors.VariableCollectorVisitor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class ExtractConstantValues
extends BaseVisitor {
    public static List<ApplesoftKeyword> TARGET_STARTS = Arrays.asList(ApplesoftKeyword.FOR, ApplesoftKeyword.CALL, ApplesoftKeyword.PLOT, ApplesoftKeyword.HLIN, ApplesoftKeyword.VLIN, ApplesoftKeyword.HCOLOR, ApplesoftKeyword.HPLOT, ApplesoftKeyword.DRAW, ApplesoftKeyword.XDRAW, ApplesoftKeyword.HTAB, ApplesoftKeyword.SCALE, ApplesoftKeyword.COLOR, ApplesoftKeyword.VTAB, ApplesoftKeyword.HIMEM, ApplesoftKeyword.LOMEM, ApplesoftKeyword.SPEED, ApplesoftKeyword.LET, ApplesoftKeyword.IF, ApplesoftKeyword.ON, ApplesoftKeyword.WAIT, ApplesoftKeyword.POKE);
    public static List<ApplesoftKeyword> TARGET_ENDS = Arrays.asList(ApplesoftKeyword.GOTO, ApplesoftKeyword.GOSUB, ApplesoftKeyword.THEN);
    private Map<String, String> map = new HashMap<String, String>();
    private VariableNameGenerator variableGenerator = new VariableNameGenerator();
    private Set<String> existingVariables;
    private Function<Token, Token> consumer = this::nullTransformation;

    public ExtractConstantValues(Configuration config) {
    }

    public Token nullTransformation(Token token) {
        return token;
    }

    public Token numberToIdentTransformation(Token token) {
        String key = token.number.toString();
        if (!this.map.containsKey(key)) {
            String varName = null;
            while (this.existingVariables.contains(varName = (String)((Optional)this.variableGenerator.get()).orElseThrow(() -> new RuntimeException("Ran out of variable names to assign")))) {
            }
            this.map.put(key, varName);
        }
        if (this.map.containsKey(key)) {
            return Token.ident(token.line, this.map.get(key));
        }
        return token;
    }

    @Override
    public Program visit(Program program) {
        VariableCollectorVisitor collector = Visitors.variableCollectorVisitor();
        program.accept(collector);
        this.existingVariables = collector.getVariableNames();
        program = super.visit(program);
        this.injectLine0(program);
        return program;
    }

    private void injectLine0(Program program) {
        Line line = this.generateLine0(program);
        if (line.statements.isEmpty()) {
            return;
        }
        if (program.lines.get((int)0).lineNumber == 0) {
            this.reassignments.put(0, 1);
            program.lines.stream().map(Line::getLineNumber).filter(this.reassignments::containsValue).forEach(n -> this.reassignments.put((Integer)n, n + 1));
        }
        program.lines.add(0, line);
    }

    private Line generateLine0(Program program) {
        Line line = new Line(0, program);
        this.map.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(this::toStatement).forEach(line.statements::add);
        return line;
    }

    private Statement toStatement(Map.Entry<String, String> variable) {
        Statement statement = new Statement();
        statement.tokens.add(Token.ident(-1, variable.getValue()));
        statement.tokens.add(Token.syntax(-1, 61));
        statement.tokens.add(Token.number(-1, Double.valueOf(variable.getKey())));
        return statement;
    }

    @Override
    public Statement visit(Statement statement) {
        try {
            if (!statement.tokens.isEmpty()) {
                Token t = statement.tokens.get(0);
                if (t.type == Token.Type.IDENT) {
                    this.consumer = this::numberToIdentTransformation;
                }
                if (t.type == Token.Type.KEYWORD && t.keyword == ApplesoftKeyword.LET) {
                    this.consumer = this::numberToIdentTransformation;
                }
            }
            Statement statement2 = super.visit(statement);
            return statement2;
        }
        finally {
            this.consumer = this::nullTransformation;
        }
    }

    @Override
    public Token visit(Token token) {
        switch (token.type) {
            case KEYWORD: {
                if (TARGET_STARTS.contains((Object)token.keyword)) {
                    this.consumer = this::numberToIdentTransformation;
                    break;
                }
                if (!TARGET_ENDS.contains((Object)token.keyword)) break;
                this.consumer = this::nullTransformation;
                break;
            }
            case NUMBER: {
                return this.consumer.apply(token);
            }
        }
        return super.visit(token);
    }
}

