/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastools.api.model;

import io.github.applecommander.bastools.api.Visitor;
import io.github.applecommander.bastools.api.model.ApplesoftKeyword;

public class Token {
    public final int line;
    public final Type type;
    public final ApplesoftKeyword keyword;
    public final Double number;
    public final String text;

    private Token(int line, Type type, ApplesoftKeyword keyword, Double number, String text) {
        this.line = line;
        this.type = type;
        this.keyword = keyword;
        this.number = number;
        this.text = text;
    }

    public Token accept(Visitor t) {
        return t.visit(this);
    }

    public String toString() {
        switch (this.type) {
            case EOL: {
                return this.type.toString();
            }
            case KEYWORD: {
                return this.keyword.toString();
            }
            case NUMBER: {
                return String.format("%s(%f)", new Object[]{this.type, this.number});
            }
        }
        return String.format("%s(%s)", new Object[]{this.type, this.text});
    }

    public String asString() {
        switch (this.type) {
            case EOL: {
                return "\n";
            }
            case KEYWORD: {
                return this.keyword.toString();
            }
            case NUMBER: {
                return this.number.toString();
            }
        }
        return this.text;
    }

    public static Token eol(int line) {
        return new Token(line, Type.EOL, null, null, null);
    }

    public static Token number(int line, Double number) {
        return new Token(line, Type.NUMBER, null, number, null);
    }

    public static Token ident(int line, String text) {
        return new Token(line, Type.IDENT, null, null, text.toUpperCase());
    }

    public static Token comment(int line, String text) {
        return new Token(line, Type.COMMENT, null, null, text);
    }

    public static Token string(int line, String text) {
        return new Token(line, Type.STRING, null, null, text);
    }

    public static Token keyword(int line, ApplesoftKeyword keyword) {
        return new Token(line, Type.KEYWORD, keyword, null, keyword.text);
    }

    public static Token syntax(int line, int ch) {
        return new Token(line, Type.SYNTAX, null, null, String.format("%c", ch));
    }

    public static Token directive(int line, String text) {
        return new Token(line, Type.DIRECTIVE, null, null, text);
    }

    public static enum Type {
        EOL,
        NUMBER,
        IDENT,
        COMMENT,
        STRING,
        KEYWORD,
        SYNTAX,
        DIRECTIVE;

    }
}

