/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastools.api.directives;

import io.github.applecommander.bastools.api.Configuration;
import io.github.applecommander.bastools.api.Directive;
import io.github.applecommander.bastools.api.model.ApplesoftKeyword;
import io.github.applecommander.bastools.api.model.Line;
import java.io.IOException;
import java.io.OutputStream;

public class HexDirective
extends Directive {
    public static final String NAME = "$hex";

    public HexDirective(Configuration config, OutputStream outputStream) {
        super(NAME, config, outputStream, new String[0]);
    }

    @Override
    public void writeBytes(int startAddress, Line line) throws IOException {
        String shortestValue;
        int value = this.requiredIntegerExpression("value", "$hex directive requires 'value' parameter");
        if (value < 0 || value > 65535) {
            throw new RuntimeException("$hex address out of range");
        }
        String value1 = Integer.toString(value);
        String value2 = Integer.toString(value - 65536);
        String string = shortestValue = value1.length() < value2.length() ? value1 : value2;
        if (shortestValue.startsWith("-")) {
            this.outputStream.write(ApplesoftKeyword.sub.code);
            shortestValue = shortestValue.substring(1);
        }
        this.outputStream.write(shortestValue.getBytes());
    }
}

