/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastools.api.directives;

import io.github.applecommander.bastools.api.Configuration;
import io.github.applecommander.bastools.api.Directive;
import io.github.applecommander.bastools.api.code.CodeBuilder;
import io.github.applecommander.bastools.api.code.CodeMark;
import io.github.applecommander.bastools.api.model.Line;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.Optional;

public class EmbeddedBinaryDirective
extends Directive {
    public static final String NAME = "$embed";
    public static final String PARAM_FILE = "file";
    public static final String PARAM_MOVETO = "moveto";
    public static final String PARAM_VAR = "var";

    public EmbeddedBinaryDirective(Configuration config, OutputStream outputStream) {
        super(NAME, config, outputStream, PARAM_FILE, PARAM_MOVETO, PARAM_VAR);
    }

    @Override
    public void writeBytes(int startAddress, Line line) throws IOException {
        String filename = this.requiredStringExpression(PARAM_FILE, "$embed requires a 'name=<string>' parameter");
        Optional<Integer> targetAddress = this.optionalIntegerExpression(PARAM_MOVETO);
        Optional<String> variableName = this.optionalStringExpression(PARAM_VAR);
        this.validateSet(ONLY_ONE, "$embed requires either a 'var' assignment or a 'moveto' parameter", targetAddress, variableName);
        File file = new File(this.config.sourceFile.getParentFile(), filename);
        byte[] bin = Files.readAllBytes(file.toPath());
        CodeBuilder builder = new CodeBuilder();
        CodeMark moveStart = new CodeMark();
        CodeMark embeddedStart = new CodeMark();
        CodeMark embeddedEnd = new CodeMark();
        variableName.ifPresent(var -> builder.basic().assign(this.resolve((String)var), embeddedStart).endStatement());
        targetAddress.ifPresent(address -> {
            builder.basic().CALL(moveStart).endStatement();
            Optional<Line> nextLine = line.nextLine();
            if (nextLine.isPresent()) {
                builder.basic().GOTO(nextLine.get().lineNumber);
            } else {
                builder.basic().RETURN();
            }
        });
        builder.basic().endLine();
        targetAddress.ifPresent(address -> builder.set(moveStart).asm().setAddress(embeddedStart, 60).setAddress(embeddedEnd, 62).setAddress((int)address, 66).ldy(0).jmp(65068).end());
        builder.set(embeddedStart).addBinary(bin).set(embeddedEnd);
        builder.generate(startAddress).writeTo(this.outputStream);
    }
}

