/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastools.api.code;

import io.github.applecommander.bastools.api.code.CodeMark;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class GeneratorState {
    private final int startAddress;
    private boolean markMoved = false;
    private ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

    public GeneratorState(int startAddress) {
        this.startAddress = startAddress;
    }

    public void reset() {
        this.markMoved = false;
        this.outputStream.reset();
    }

    public boolean hasMarkMoved() {
        return this.markMoved;
    }

    public void update(CodeMark mark) {
        this.markMoved |= mark.update(this);
    }

    public ByteArrayOutputStream outputStream() {
        return this.outputStream;
    }

    public int currentAddress() {
        return this.startAddress + this.outputStream.size();
    }

    public void write(int b) {
        this.outputStream.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.outputStream.write(b);
    }
}

