/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastools.api.code;

import io.github.applecommander.bastools.api.code.AsmBuilder;
import io.github.applecommander.bastools.api.code.BasicBuilder;
import io.github.applecommander.bastools.api.code.CodeGenerator;
import io.github.applecommander.bastools.api.code.CodeMark;
import io.github.applecommander.bastools.api.code.GeneratorState;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class CodeBuilder {
    private CodeGenerator generatorChain = os -> {};

    public ByteArrayOutputStream generate(int startAddress) throws IOException {
        GeneratorState state = new GeneratorState(startAddress);
        do {
            state.reset();
            this.generatorChain.generate(state);
        } while (state.hasMarkMoved());
        return state.outputStream();
    }

    public BasicBuilder basic() {
        return new BasicBuilder(this);
    }

    public AsmBuilder asm() {
        return new AsmBuilder(this);
    }

    public CodeBuilder add(CodeGenerator generator) {
        this.generatorChain = this.generatorChain.andThen(generator);
        return this;
    }

    public CodeBuilder set(CodeMark mark) {
        return this.add(state -> state.update(mark));
    }

    public CodeBuilder addBinary(byte[] data) {
        return this.add(state -> state.write(data));
    }
}

