/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastools.api.code;

import io.github.applecommander.bastools.api.code.CodeBuilder;
import io.github.applecommander.bastools.api.code.CodeMark;
import io.github.applecommander.bastools.api.model.ApplesoftKeyword;
import java.util.Objects;

public class BasicBuilder {
    private CodeBuilder builder;

    public BasicBuilder(CodeBuilder builder) {
        Objects.requireNonNull(builder);
        this.builder = builder;
    }

    public CodeBuilder end() {
        return this.builder;
    }

    public BasicBuilder RETURN() {
        this.builder.add(state -> state.write(ApplesoftKeyword.RETURN.code));
        return this;
    }

    public BasicBuilder GOTO(int lineNumber) {
        this.builder.add(state -> {
            state.write(ApplesoftKeyword.GOTO.code);
            state.write(Integer.toString(lineNumber).getBytes());
        });
        return this;
    }

    public BasicBuilder GOSUB(int lineNumber) {
        this.builder.add(state -> {
            state.write(ApplesoftKeyword.GOSUB.code);
            state.write(Integer.toString(lineNumber).getBytes());
        });
        return this;
    }

    public BasicBuilder CALL(CodeMark mark) {
        this.builder.add(state -> {
            int address = mark.getAddress();
            state.write(ApplesoftKeyword.CALL.code);
            state.write(Integer.toString(address).getBytes());
        });
        return this;
    }

    public BasicBuilder POKEW(int address, CodeMark mark) {
        this.builder.add(state -> {
            int value = mark.getAddress();
            state.write(ApplesoftKeyword.POKE.code);
            state.write(Integer.toString(address).getBytes());
            state.write(44);
            state.write(Integer.toString(value & 0xFF).getBytes());
            state.write(58);
            state.write(ApplesoftKeyword.POKE.code);
            state.write(Integer.toString(address + 1).getBytes());
            state.write(44);
            state.write(Integer.toString(value >> 8).getBytes());
        });
        return this;
    }

    public BasicBuilder endStatement() {
        this.builder.add(state -> state.write(58));
        return this;
    }

    public BasicBuilder assign(String varName, CodeMark mark) {
        this.builder.add(state -> {
            state.write(varName.getBytes());
            state.write(ApplesoftKeyword.eq.code);
            state.write(Integer.toString(mark.getAddress()).getBytes());
        });
        return this;
    }

    public BasicBuilder assign(String varName, int value) {
        this.builder.add(state -> {
            state.write(varName.getBytes());
            state.write(ApplesoftKeyword.eq.code);
            state.write(Integer.toString(value).getBytes());
        });
        return this;
    }

    public CodeBuilder endLine() {
        this.builder.add(state -> state.write(0));
        return this.builder;
    }

    public BasicBuilder ROT(int lineNumber) {
        this.builder.add(state -> {
            state.write(ApplesoftKeyword.ROT.code);
            state.write(Integer.toString(lineNumber).getBytes());
        });
        return this;
    }

    public BasicBuilder SCALE(int lineNumber) {
        this.builder.add(state -> {
            state.write(ApplesoftKeyword.SCALE.code);
            state.write(Integer.toString(lineNumber).getBytes());
        });
        return this;
    }

    public BasicBuilder HCOLOR(int lineNumber) {
        this.builder.add(state -> {
            state.write(ApplesoftKeyword.HCOLOR.code);
            state.write(Integer.toString(lineNumber).getBytes());
        });
        return this;
    }
}

