/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastools.api.code;

import io.github.applecommander.bastools.api.code.CodeBuilder;
import io.github.applecommander.bastools.api.code.CodeMark;
import io.github.applecommander.bastools.api.code.GeneratorState;
import java.io.IOException;
import java.util.Objects;

public class AsmBuilder {
    private CodeBuilder builder;

    public AsmBuilder(CodeBuilder builder) {
        Objects.requireNonNull(builder);
        this.builder = builder;
    }

    public CodeBuilder end() {
        return this.builder;
    }

    public AsmBuilder ldy(int value) {
        this.builder.add(state -> this.internalLDY(state, value));
        return this;
    }

    public AsmBuilder jmp(int address) {
        this.builder.add(state -> this.internalJMP(state, address));
        return this;
    }

    public AsmBuilder lda(int value) throws IOException {
        this.builder.add(state -> this.internalLDA(state, value));
        return this;
    }

    public AsmBuilder sta(int address) throws IOException {
        this.builder.add(state -> this.internalSTA(state, address));
        return this;
    }

    public AsmBuilder setAddress(int value, int address) {
        this.builder.add(state -> {
            this.internalLDA(state, value & 0xFF);
            this.internalSTA(state, address);
            this.internalLDA(state, value >> 8);
            this.internalSTA(state, address + 1);
        });
        return this;
    }

    public AsmBuilder setAddress(CodeMark mark, int address) {
        this.builder.add(state -> {
            int value = mark.getAddress();
            this.internalLDA(state, value & 0xFF);
            this.internalSTA(state, address);
            this.internalLDA(state, value >> 8);
            this.internalSTA(state, address + 1);
        });
        return this;
    }

    private void internalJMP(GeneratorState state, int address) {
        state.write(76);
        state.write(address & 0xFF);
        state.write(address >> 8);
    }

    private void internalLDY(GeneratorState state, int value) {
        state.write(160);
        state.write(value);
    }

    private void internalLDA(GeneratorState state, int value) {
        state.write(169);
        state.write(value);
    }

    private void internalSTA(GeneratorState state, int address) {
        if ((address & 0xFF00) != 0) {
            throw new RuntimeException("sta does not handle 16 bit addresses yet!");
        }
        state.write(133);
        state.write(address);
    }
}

