/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastools.api;

import io.github.applecommander.bastools.api.model.ApplesoftKeyword;
import io.github.applecommander.bastools.api.model.Token;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Queue;

public class TokenReader {
    private boolean hasMore = true;
    private boolean needSyntheticEol = false;
    private Reader reader;
    private StreamTokenizer tokenizer;

    public static Queue<Token> tokenize(String filename) throws FileNotFoundException, IOException {
        try (FileReader fileReader = new FileReader(filename);){
            Queue<Token> queue = TokenReader.tokenize(fileReader);
            return queue;
        }
    }

    public static Queue<Token> tokenize(File file) throws FileNotFoundException, IOException {
        try (FileReader fileReader = new FileReader(file);){
            Queue<Token> queue = TokenReader.tokenize(fileReader);
            return queue;
        }
    }

    public static Queue<Token> tokenize(InputStream inputStream) throws IOException {
        try (InputStreamReader streamReader = new InputStreamReader(inputStream);){
            Queue<Token> queue = TokenReader.tokenize(streamReader);
            return queue;
        }
    }

    private static Queue<Token> tokenize(Reader reader) throws IOException {
        TokenReader tokenReader = new TokenReader(reader);
        LinkedList<Token> tokens = new LinkedList<Token>();
        while (tokenReader.hasMore()) {
            tokenReader.next(2).ifPresent(tokens::add);
        }
        return tokens;
    }

    private TokenReader(Reader reader) {
        this.reader = reader;
        this.tokenizer = ApplesoftKeyword.tokenizer(reader);
    }

    private boolean hasMore() {
        return this.hasMore;
    }

    private Optional<Token> next(int depth) throws IOException {
        if (depth > 0) {
            if (this.needSyntheticEol) {
                this.needSyntheticEol = false;
                int line = this.tokenizer.lineno();
                return Optional.of(Token.eol(line));
            }
            boolean bl = this.hasMore = this.tokenizer.nextToken() != -1;
            if (this.hasMore) {
                int line = this.tokenizer.lineno();
                switch (this.tokenizer.ttype) {
                    case 10: {
                        return Optional.of(Token.eol(line));
                    }
                    case -2: {
                        return Optional.of(Token.number(line, this.tokenizer.nval));
                    }
                    case -3: {
                        Optional<ApplesoftKeyword> opt = ApplesoftKeyword.find(this.tokenizer.sval);
                        if (opt.filter(kw -> kw == ApplesoftKeyword.REM).isPresent()) {
                            StringBuilder sb = new StringBuilder();
                            while (true) {
                                int ch;
                                if ((ch = this.reader.read()) == 10) break;
                                sb.append((char)ch);
                            }
                            this.needSyntheticEol = true;
                            return Optional.of(Token.comment(line, sb.toString()));
                        }
                        if (opt.isPresent()) {
                            if (opt.get().parts.size() > 1) {
                                this.next(depth - 1).filter(t -> ((ApplesoftKeyword)((Object)((Object)opt.get()))).parts.get(1).equals(t.text)).orElseThrow(() -> new IOException("Expecting: " + ((ApplesoftKeyword)((Object)((Object)opt.get()))).parts));
                            }
                            ApplesoftKeyword outKeyword = opt.get();
                            if (opt.filter(kw -> kw == ApplesoftKeyword.questionmark).isPresent()) {
                                outKeyword = ApplesoftKeyword.PRINT;
                            }
                            return Optional.of(Token.keyword(line, outKeyword));
                        }
                        if (this.tokenizer.sval.startsWith("$")) {
                            return Optional.of(Token.directive(line, this.tokenizer.sval));
                        }
                        Object sval = this.tokenizer.sval;
                        this.tokenizer.nextToken();
                        if (this.tokenizer.ttype == 40) {
                            sval = (String)sval + (char)this.tokenizer.ttype;
                        } else {
                            this.tokenizer.pushBack();
                        }
                        return Optional.of(Token.ident(line, (String)sval));
                    }
                    case 34: {
                        return Optional.of(Token.string(line, this.tokenizer.sval));
                    }
                    case 35: 
                    case 36: 
                    case 38: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 47: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 94: {
                        return Optional.of(ApplesoftKeyword.find(String.format("%c", this.tokenizer.ttype)).map(kw -> Token.keyword(line, kw)).orElse(Token.syntax(line, this.tokenizer.ttype)));
                    }
                    case 92: {
                        if (this.tokenizer.nextToken() == 10) break;
                    }
                    default: {
                        Object message = String.format("Unknown or unexpected character '%c'", this.tokenizer.ttype);
                        if (this.tokenizer.ttype == -3) {
                            message = String.format("Unknown or unexpected string '%s'", this.tokenizer.sval);
                        } else if (this.tokenizer.ttype == -2) {
                            message = String.format("Unknown or unexpected number %f", this.tokenizer.nval);
                        } else if (this.tokenizer.ttype == -1) {
                            message = "Unexpected EOF";
                        } else if (this.tokenizer.ttype == 10) {
                            message = "Unexpected EOL";
                        }
                        message = (String)message + String.format(" found on line #%d", this.tokenizer.lineno());
                        throw new IOException((String)message);
                    }
                }
            }
        }
        return Optional.empty();
    }
}

