/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastools.api;

import io.github.applecommander.bastools.api.Configuration;
import io.github.applecommander.bastools.api.Visitor;
import io.github.applecommander.bastools.api.optimizations.ExtractConstantValues;
import io.github.applecommander.bastools.api.optimizations.MergeLines;
import io.github.applecommander.bastools.api.optimizations.RemoveEmptyStatements;
import io.github.applecommander.bastools.api.optimizations.RemoveRemStatements;
import io.github.applecommander.bastools.api.optimizations.Renumber;
import io.github.applecommander.bastools.api.optimizations.ShortenVariableNames;
import java.util.function.Function;

public enum Optimization {
    REMOVE_EMPTY_STATEMENTS(RemoveEmptyStatements::new),
    REMOVE_REM_STATEMENTS(RemoveRemStatements::new),
    SHORTEN_VARIABLE_NAMES(ShortenVariableNames::new),
    EXTRACT_CONSTANT_VALUES(ExtractConstantValues::new),
    MERGE_LINES(MergeLines::new),
    RENUMBER(Renumber::new);

    private Function<Configuration, Visitor> factory;

    private Optimization(Function<Configuration, Visitor> factory) {
        this.factory = factory;
    }

    public Visitor create(Configuration config) {
        return this.factory.apply(config);
    }
}

