/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastools.api;

import io.github.applecommander.bastools.api.Configuration;
import io.github.applecommander.bastools.api.model.ApplesoftKeyword;
import io.github.applecommander.bastools.api.model.Line;
import io.github.applecommander.bastools.api.model.Token;
import io.github.applecommander.bastools.api.utils.Converters;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;

public abstract class Directive {
    private String directiveName;
    protected Configuration config;
    protected OutputStream outputStream;
    private List<Token> paramTokens = new ArrayList<Token>();
    private Map<String, Expression> parameters = new TreeMap<String, Expression>(String::compareToIgnoreCase);
    private Set<String> parameterNames;
    public static final Predicate<Integer> ONLY_ONE = n -> n == 1;
    public static final Predicate<Integer> ZERO_OR_ONE = n -> n <= 1;
    public static final Predicate<Integer> ZERO = n -> n == 0;

    protected Directive(String directiveName, Configuration config, OutputStream outputStream, String ... parameterNames) {
        Objects.requireNonNull(directiveName);
        Objects.requireNonNull(config);
        Objects.requireNonNull(outputStream);
        this.directiveName = directiveName;
        this.config = config;
        this.outputStream = outputStream;
        this.parameterNames = new TreeSet<String>(String::compareToIgnoreCase);
        this.parameterNames.addAll(Arrays.asList(parameterNames));
    }

    public String resolve(String originalVariableName) {
        if (this.config.variableReplacements.containsKey(originalVariableName)) {
            String replacementVariableName = this.config.variableReplacements.get(originalVariableName);
            this.config.debugStream.printf("Replacing '%s' with '%s'\n", originalVariableName, replacementVariableName);
            return replacementVariableName;
        }
        return originalVariableName;
    }

    public Optional<Expression> optionalExpression(String paramName) {
        return Optional.ofNullable(this.parameters.get(paramName));
    }

    public Optional<Integer> optionalIntegerExpression(String paramName) {
        return this.optionalExpression(paramName).flatMap(Expression::toSimpleExpression).map(SimpleExpression::asInteger);
    }

    public Integer requiredIntegerExpression(String paramName, String errorMessage) {
        return this.optionalIntegerExpression(paramName).orElseThrow(() -> new RuntimeException(errorMessage));
    }

    public Optional<String> optionalStringExpression(String paramName) {
        return this.optionalExpression(paramName).flatMap(Expression::toSimpleExpression).map(SimpleExpression::asString);
    }

    public boolean defaultBooleanExpression(String paramName, boolean defaultValue) {
        return this.optionalExpression(paramName).flatMap(Expression::toSimpleExpression).map(SimpleExpression::asBoolean).orElse(defaultValue);
    }

    public String requiredStringExpression(String paramName, String errorMessage) {
        return this.optionalStringExpression(paramName).orElseThrow(() -> new RuntimeException(errorMessage));
    }

    public Optional<MapExpression> optionalMapExpression(String paramName) {
        return this.optionalExpression(paramName).flatMap(Expression::toMapExpression);
    }

    public void validateSet(Predicate<Integer> validator, String message, Optional<?> ... opts) {
        int count = 0;
        for (Optional<?> opt : opts) {
            if (!opt.isPresent()) continue;
            ++count;
        }
        if (!validator.test(count)) {
            throw new RuntimeException(message);
        }
    }

    public void append(Token token) {
        if (token.type == Token.Type.EOL) {
            while (!this.paramTokens.isEmpty()) {
                String name = this.requireIdentToken();
                if (!this.parameterNames.contains(name)) {
                    String message = String.format("Parameter '%s' is invalid for %s directive", name, this.directiveName);
                    throw new RuntimeException(message);
                }
                this.requireSyntaxToken("=");
                Expression expr = this.buildExpression();
                this.parameters.put(name, expr);
                if (this.paramTokens.isEmpty()) continue;
                this.requireSyntaxToken(",");
            }
        } else {
            this.paramTokens.add(token);
        }
    }

    private Expression buildExpression() {
        Token t = this.paramTokens.get(0);
        if ("(".equals(t.text)) {
            this.requireSyntaxToken("(");
            Expression expr = this.buildMapExpression();
            this.requireSyntaxToken(")");
            return expr;
        }
        return this.buildSimpleExpression();
    }

    private Expression buildSimpleExpression() {
        Token t = this.paramTokens.remove(0);
        return new SimpleExpression(t.asString());
    }

    private Expression buildMapExpression() {
        MapExpression mapex = new MapExpression();
        boolean more = true;
        while (more) {
            String key = this.requireIdentToken();
            this.requireSyntaxToken("=");
            Expression expr = this.buildExpression();
            mapex.expressions.put(key, expr);
            more = this.checkSyntaxToken(",");
            if (!more) continue;
            this.requireSyntaxToken(",");
        }
        return mapex;
    }

    private Token requireToken(Token.Type ... types) {
        Token t = this.paramTokens.remove(0);
        boolean matches = false;
        for (Token.Type type : types) {
            matches |= type == t.type;
        }
        if (!matches) {
            String message = String.format("Expecting a token type of %s but found %s instead", new Object[]{Arrays.asList(types), t.type});
            throw new IllegalArgumentException(message);
        }
        return t;
    }

    private String requireIdentToken() {
        Token t = this.requireToken(Token.Type.IDENT, Token.Type.KEYWORD);
        return t.text;
    }

    private void requireSyntaxToken(String syntax) {
        try {
            Token.Type tokenType = ApplesoftKeyword.find(syntax).map(t -> Token.Type.KEYWORD).orElse(Token.Type.SYNTAX);
            Token token = this.requireToken(tokenType);
            if (!syntax.equals(token.text)) {
                String message = String.format("Expecting '%s' but found '%s' instead", syntax, token.text);
                throw new RuntimeException(message);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(String.format("Failed when token of '%s' was required", syntax));
        }
    }

    private boolean checkSyntaxToken(String syntax) {
        if (this.paramTokens.isEmpty()) {
            return false;
        }
        Token.Type tokenType = ApplesoftKeyword.find(syntax).map(t -> Token.Type.KEYWORD).orElse(Token.Type.SYNTAX);
        Token token = this.paramTokens.get(0);
        return tokenType == token.type && syntax.equals(token.text);
    }

    public abstract void writeBytes(int var1, Line var2) throws IOException;

    public static class MapExpression
    implements Expression {
        private final Map<String, Expression> expressions = new HashMap<String, Expression>();

        public Optional<Expression> get(String key) {
            return Optional.ofNullable(this.expressions.get(key));
        }

        public Set<Map.Entry<String, Expression>> entrySet() {
            return this.expressions.entrySet();
        }

        @Override
        public Optional<SimpleExpression> toSimpleExpression() {
            return Optional.empty();
        }

        @Override
        public Optional<MapExpression> toMapExpression() {
            return Optional.of(this);
        }
    }

    public static class SimpleExpression
    implements Expression {
        private final String value;

        public SimpleExpression(String value) {
            this.value = value;
        }

        public String asString() {
            return this.value;
        }

        public Boolean asBoolean() {
            return Converters.toBoolean(this.value);
        }

        public Integer asInteger() {
            return Converters.toInteger(this.value);
        }

        @Override
        public Optional<SimpleExpression> toSimpleExpression() {
            return Optional.of(this);
        }

        @Override
        public Optional<MapExpression> toMapExpression() {
            return Optional.empty();
        }
    }

    public static interface Expression {
        public Optional<SimpleExpression> toSimpleExpression();

        public Optional<MapExpression> toMapExpression();
    }

    public static class Variable {
        public final String name;
        public final Expression expr;

        private Variable(String name, Expression expr) {
            this.name = name;
            this.expr = expr;
        }
    }
}

