/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastokenizer.api.visitors;

import io.github.applecommander.bastokenizer.api.Visitor;
import io.github.applecommander.bastokenizer.api.model.Line;
import io.github.applecommander.bastokenizer.api.model.Program;
import io.github.applecommander.bastokenizer.api.model.Token;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class VariableReportVisitor
implements Visitor {
    private Map<String, SortedSet<Integer>> refs = new HashMap<String, SortedSet<Integer>>();
    private int currentLineNumber = -1;

    @Override
    public Program visit(Program program) {
        Program p = Visitor.super.visit(program);
        this.refs.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(this::print);
        return p;
    }

    private void print(Map.Entry<String, SortedSet<Integer>> e) {
        System.out.printf("%-8s  ", e.getKey());
        int c = 0;
        Iterator iterator = e.getValue().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (c > 0) {
                System.out.print(", ");
            }
            if (c > 0 && c % 10 == 0) {
                System.out.printf("\n          ", new Object[0]);
            }
            System.out.print(i);
            ++c;
        }
        System.out.println();
    }

    @Override
    public Line visit(Line line) {
        this.currentLineNumber = line.lineNumber;
        return Visitor.super.visit(line);
    }

    @Override
    public Token visit(Token token) {
        if (token.type == Token.Type.IDENT) {
            this.refs.merge(token.text, new TreeSet<Integer>(Arrays.asList(this.currentLineNumber)), (a, b) -> {
                a.addAll(b);
                return a;
            });
        }
        return Visitor.super.visit(token);
    }
}

