/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastokenizer.api.visitors;

import io.github.applecommander.bastokenizer.api.Configuration;
import io.github.applecommander.bastokenizer.api.Directive;
import io.github.applecommander.bastokenizer.api.Directives;
import io.github.applecommander.bastokenizer.api.Visitor;
import io.github.applecommander.bastokenizer.api.model.ApplesoftKeyword;
import io.github.applecommander.bastokenizer.api.model.Line;
import io.github.applecommander.bastokenizer.api.model.Program;
import io.github.applecommander.bastokenizer.api.model.Statement;
import io.github.applecommander.bastokenizer.api.model.Token;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.TreeMap;

public class ByteVisitor
implements Visitor {
    private Stack<ByteArrayOutputStream> stack;
    private Map<Integer, Integer> lineAddresses;
    private Configuration config;
    private int address;
    private Directive currentDirective;

    public ByteVisitor(Configuration config) {
        this.config = config;
        this.address = config.startAddress;
        this.stack = new Stack();
        this.lineAddresses = new TreeMap<Integer, Integer>();
    }

    public byte[] dump(Program program) {
        program.accept(this);
        return this.getBytes();
    }

    public int length(Line line) {
        this.stack.push(new ByteArrayOutputStream());
        line.accept(this);
        return this.stack.pop().size();
    }

    public Map<Integer, Integer> getLineAddresses() {
        return this.lineAddresses;
    }

    public byte[] getBytes() {
        if (this.stack.size() != 1) {
            throw new RuntimeException("Error in processing internal BASIC model!");
        }
        return this.stack.peek().toByteArray();
    }

    @Override
    public Program visit(Program program) {
        this.stack.clear();
        this.stack.push(new ByteArrayOutputStream());
        program.lines.forEach(line -> line.accept(this));
        ByteArrayOutputStream os = this.stack.peek();
        os.write(0);
        os.write(0);
        return program;
    }

    @Override
    public Line visit(Line line) {
        try {
            this.stack.push(new ByteArrayOutputStream());
            boolean first = true;
            for (Statement statement : line.statements) {
                if (this.currentDirective != null) {
                    throw new RuntimeException("No statements are allowed after a directive!");
                }
                if (!first) {
                    this.stack.peek().write(58);
                }
                first = false;
                statement.accept(this);
            }
            if (this.currentDirective != null) {
                this.currentDirective.writeBytes(this.address + 4, line);
                this.currentDirective = null;
            }
            this.lineAddresses.put(line.lineNumber, this.address);
            byte[] content = this.stack.pop().toByteArray();
            int nextAddress = this.address + content.length + 5;
            ByteArrayOutputStream os = this.stack.peek();
            os.write(nextAddress);
            os.write(nextAddress >> 8);
            os.write(line.lineNumber);
            os.write(line.lineNumber >> 8);
            os.write(content);
            os.write(0);
            this.address = nextAddress;
            return line;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Token visit(Token token) {
        if (this.currentDirective != null) {
            this.currentDirective.append(token);
            return token;
        }
        try {
            ByteArrayOutputStream os = this.stack.peek();
            switch (token.type) {
                case COMMENT: {
                    os.write(ApplesoftKeyword.REM.code);
                    os.write(token.text.getBytes());
                    break;
                }
                case EOL: {
                    os.write(0);
                    break;
                }
                case IDENT: {
                    os.write(token.text.getBytes());
                    break;
                }
                case KEYWORD: {
                    os.write(token.keyword.code);
                    break;
                }
                case DIRECTIVE: {
                    this.currentDirective = Directives.find(token.text, this.config, os);
                    break;
                }
                case NUMBER: {
                    if (Math.rint(token.number) == token.number) {
                        os.write(Integer.toString(token.number.intValue()).getBytes());
                        break;
                    }
                    os.write(Double.toString(token.number).getBytes());
                    break;
                }
                case STRING: {
                    os.write(34);
                    os.write(token.text.getBytes());
                    os.write(34);
                    break;
                }
                case SYNTAX: {
                    Optional<ApplesoftKeyword> opt = ApplesoftKeyword.find(token.text);
                    if (opt.isPresent()) {
                        os.write(opt.get().code);
                        break;
                    }
                    os.write(token.text.getBytes());
                }
            }
            return token;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

