/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastokenizer.api.optimizations;

import io.github.applecommander.bastokenizer.api.Configuration;
import io.github.applecommander.bastokenizer.api.Visitors;
import io.github.applecommander.bastokenizer.api.model.ApplesoftKeyword;
import io.github.applecommander.bastokenizer.api.model.Line;
import io.github.applecommander.bastokenizer.api.model.Program;
import io.github.applecommander.bastokenizer.api.model.Statement;
import io.github.applecommander.bastokenizer.api.model.Token;
import io.github.applecommander.bastokenizer.api.optimizations.BaseVisitor;
import io.github.applecommander.bastokenizer.api.visitors.ByteVisitor;
import io.github.applecommander.bastokenizer.api.visitors.LineNumberTargetCollector;
import java.io.PrintStream;
import java.util.Set;

public class MergeLines
extends BaseVisitor {
    private Set<Integer> targets;
    private Line mergeLine;
    private ByteVisitor bv;
    private int maxLineLength;
    private PrintStream debugStream;

    public MergeLines(Configuration config) {
        this.maxLineLength = config.maxLineLength;
        this.debugStream = config.debugStream;
        this.bv = Visitors.byteVisitor(config);
    }

    @Override
    public Program visit(Program program) {
        LineNumberTargetCollector c = Visitors.lineNumberTargetCollector();
        program.accept(c);
        this.targets = c.getTargets();
        this.debugStream.printf("Target lines = %s\n", this.targets);
        return super.visit(program);
    }

    @Override
    public Line visit(Line line) {
        this.debugStream.printf("Line # %d : ", line.lineNumber);
        Line newLine = new Line(line.lineNumber, this.newProgram);
        newLine.statements.addAll(line.statements);
        if (this.mergeLine == null || this.targets.contains(line.lineNumber)) {
            this.debugStream.printf("%s\n", this.mergeLine == null ? "mergeLine is null" : "target line #");
        } else {
            Line tmpLine = new Line(this.mergeLine.lineNumber, this.mergeLine.program);
            tmpLine.statements.addAll(this.mergeLine.statements);
            tmpLine.statements.addAll(line.statements);
            if (this.bv.length(tmpLine) > this.maxLineLength) {
                this.debugStream.printf("merge would exceed max line length: %d > %d\n", this.bv.length(tmpLine), this.maxLineLength);
            } else {
                this.mergeLine.statements.addAll(line.statements);
                if (this.hasTerminal(line)) {
                    this.mergeLine = null;
                }
                this.debugStream.printf("line %s\n", this.mergeLine == null ? "had terminals" : "was added to mergeLine");
                return null;
            }
        }
        this.mergeLine = this.hasTerminal(line) ? null : newLine;
        this.debugStream.printf("line %s\n", this.mergeLine == null ? "had terminals" : "is now mergeLine");
        return newLine;
    }

    private boolean hasTerminal(Line line) {
        for (Statement s : line.statements) {
            for (Token t : s.tokens) {
                boolean terminal = t.keyword == ApplesoftKeyword.IF || t.type == Token.Type.COMMENT || t.keyword == ApplesoftKeyword.GOTO || t.keyword == ApplesoftKeyword.END || t.keyword == ApplesoftKeyword.RESUME || t.keyword == ApplesoftKeyword.RETURN || t.keyword == ApplesoftKeyword.STOP || t.type == Token.Type.DIRECTIVE;
                if (!terminal) continue;
                return true;
            }
        }
        return false;
    }
}

