/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastokenizer.api.optimizations;

import io.github.applecommander.bastokenizer.api.Visitor;
import io.github.applecommander.bastokenizer.api.Visitors;
import io.github.applecommander.bastokenizer.api.model.Line;
import io.github.applecommander.bastokenizer.api.model.Program;
import io.github.applecommander.bastokenizer.api.model.Statement;
import io.github.applecommander.bastokenizer.api.model.Token;
import java.util.HashMap;
import java.util.Map;

public class BaseVisitor
implements Visitor {
    protected Map<Integer, Integer> reassignments = new HashMap<Integer, Integer>();
    protected Program newProgram;

    @Override
    public Program visit(Program program) {
        this.newProgram = new Program();
        program.lines.forEach(l -> {
            boolean lineKept;
            Line line = l.accept(this);
            boolean bl = lineKept = line != null && !line.statements.isEmpty();
            if (lineKept) {
                this.newProgram.lines.add(line);
                this.reassignments.replaceAll((k, v) -> v == null ? l.lineNumber : v);
            } else {
                this.reassignments.put(l.lineNumber, null);
            }
        });
        if (!this.reassignments.isEmpty()) {
            return this.newProgram.accept(Visitors.reassignVisitor(this.reassignments));
        }
        return this.newProgram;
    }

    @Override
    public Line visit(Line line) {
        Line newLine = new Line(line.lineNumber, this.newProgram);
        line.statements.forEach(s -> {
            Statement statement = s.accept(this);
            if (statement != null) {
                newLine.statements.add(statement);
            }
        });
        return newLine;
    }

    @Override
    public Statement visit(Statement statement) {
        Statement newStatement = new Statement();
        statement.tokens.forEach(t -> {
            Token token = t.accept(this);
            if (token != null) {
                newStatement.tokens.add(token);
            }
        });
        return newStatement;
    }

    @Override
    public Token visit(Token token) {
        return token;
    }
}

