/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastokenizer.api.model;

import io.github.applecommander.bastokenizer.api.Visitor;
import io.github.applecommander.bastokenizer.api.model.Program;
import io.github.applecommander.bastokenizer.api.model.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Line {
    public final Program program;
    public final int lineNumber;
    public final List<Statement> statements = new ArrayList<Statement>();

    public Line(int lineNumber, Program program) {
        Objects.requireNonNull(program);
        this.lineNumber = lineNumber;
        this.program = program;
    }

    public Optional<Line> nextLine() {
        int i = this.program.lines.indexOf(this);
        if (i == -1 || i + 1 >= this.program.lines.size()) {
            return Optional.empty();
        }
        return Optional.of(this.program.lines.get(i + 1));
    }

    public Line accept(Visitor t) {
        return t.visit(this);
    }
}

