/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastokenizer.api.model;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public enum ApplesoftKeyword {
    END(128, "END"),
    FOR(129, "FOR"),
    NEXT(130, "NEXT"),
    DATA(131, "DATA"),
    INPUT(132, "INPUT"),
    DEL(133, "DEL"),
    DIM(134, "DIM"),
    READ(135, "READ"),
    GR(136, "GR"),
    TEXT(137, "TEXT"),
    PR(138, "PR#"),
    IN(139, "IN#"),
    CALL(140, "CALL"),
    PLOT(141, "PLOT"),
    HLIN(142, "HLIN"),
    VLIN(143, "VLIN"),
    HGR2(144, "HGR2"),
    HGR(145, "HGR"),
    HCOLOR(146, "HCOLOR="),
    HPLOT(147, "HPLOT"),
    DRAW(148, "DRAW"),
    XDRAW(149, "XDRAW"),
    HTAB(150, "HTAB"),
    HOME(151, "HOME"),
    ROT(152, "ROT="),
    SCALE(153, "SCALE="),
    SHLOAD(154, "SHLOAD"),
    TRACE(155, "TRACE"),
    NOTRACE(156, "NOTRACE"),
    NORMAL(157, "NORMAL"),
    INVERSE(158, "INVERSE"),
    FLASH(159, "FLASH"),
    COLOR(160, "COLOR="),
    POP(161, "POP"),
    VTAB(162, "VTAB"),
    HIMEM(163, "HIMEM:"),
    LOMEM(164, "LOMEM:"),
    ONERR(165, "ONERR"),
    RESUME(166, "RESUME"),
    RECALL(167, "RECALL"),
    STORE(168, "STORE"),
    SPEED(169, "SPEED="),
    LET(170, "LET"),
    GOTO(171, "GOTO"),
    RUN(172, "RUN"),
    IF(173, "IF"),
    RESTORE(174, "RESTORE"),
    amp(175, "&"),
    GOSUB(176, "GOSUB"),
    RETURN(177, "RETURN"),
    REM(178, "REM"),
    STOP(179, "STOP"),
    ON(180, "ON"),
    WAIT(181, "WAIT"),
    LOAD(182, "LOAD"),
    SAVE(183, "SAVE"),
    DEF(184, "DEF"),
    POKE(185, "POKE"),
    PRINT(186, "PRINT"),
    CONT(187, "CONT"),
    LIST(188, "LIST"),
    CLEAR(189, "CLEAR"),
    GET(190, "GET"),
    NEW(191, "NEW"),
    TAB(192, "TAB("),
    TO(193, "TO"),
    FN(194, "FN"),
    SPC(195, "SPC("),
    THEN(196, "THEN"),
    AT(197, "AT"),
    NOT(198, "NOT"),
    STEP(199, "STEP"),
    add(200, "+"),
    sub(201, "-"),
    mul(202, "*"),
    div(203, "/"),
    pow(204, "^"),
    AND(205, "AND"),
    OR(206, "OR"),
    gt(207, ">"),
    eq(208, "="),
    lt(209, "<"),
    SGN(210, "SGN"),
    INT(211, "INT"),
    ABS(212, "ABS"),
    USR(213, "USR"),
    FRE(214, "FRE"),
    SCRN(215, "SCRN("),
    PDL(216, "PDL"),
    POS(217, "POS"),
    SQR(218, "SQR"),
    RND(219, "RND"),
    LOG(220, "LOG"),
    EXP(221, "EXP"),
    COS(222, "COS"),
    SIN(223, "SIN"),
    TAN(224, "TAN"),
    ATN(225, "ATN"),
    PEEK(226, "PEEK"),
    LEN(227, "LEN"),
    STR(228, "STR$"),
    VAL(229, "VAL"),
    ASC(230, "ASC"),
    CHR(231, "CHR$"),
    LEFT(232, "LEFT$"),
    RIGHT(233, "RIGHT$"),
    MID(234, "MID$");

    public final int code;
    public final String text;
    public final List<String> parts;
    public boolean needsRParen;

    private ApplesoftKeyword(int code, String text) {
        this.code = code;
        this.text = text;
        try {
            ArrayList<String> list = new ArrayList<String>();
            StreamTokenizer t = ApplesoftKeyword.tokenizer(new StringReader(text));
            block5: while (t.nextToken() != -1) {
                switch (t.ttype) {
                    case -3: {
                        list.add(t.sval);
                        continue block5;
                    }
                }
                list.add(String.format("%c", t.ttype));
            }
            this.parts = Collections.unmodifiableList(list);
            this.needsRParen = this.parts.contains("(");
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean equalsIgnoreCase(String value) {
        return this.text.equalsIgnoreCase(value);
    }

    public String toString() {
        return String.format("%s (%02x)", this.text, this.code);
    }

    public static StreamTokenizer tokenizer(Reader r) {
        StreamTokenizer tokenizer = new StreamTokenizer(r);
        tokenizer.resetSyntax();
        tokenizer.wordChars(97, 122);
        tokenizer.wordChars(65, 90);
        tokenizer.wordChars(36, 36);
        tokenizer.wordChars(37, 37);
        tokenizer.wordChars(160, 255);
        tokenizer.whitespaceChars(0, 32);
        tokenizer.quoteChar(34);
        tokenizer.parseNumbers();
        tokenizer.ordinaryChar(45);
        tokenizer.eolIsSignificant(true);
        return tokenizer;
    }

    public static Optional<ApplesoftKeyword> find(String value) {
        Objects.requireNonNull(value);
        for (ApplesoftKeyword kw : ApplesoftKeyword.values()) {
            if (!value.equalsIgnoreCase(kw.parts.get(0))) continue;
            return Optional.of(kw);
        }
        return Optional.empty();
    }
}

