/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastokenizer.api.directives;

import io.github.applecommander.bastokenizer.api.Configuration;
import io.github.applecommander.bastokenizer.api.Directive;
import io.github.applecommander.bastokenizer.api.model.ApplesoftKeyword;
import io.github.applecommander.bastokenizer.api.model.Line;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.Optional;

public class EmbeddedBinaryDirective
extends Directive {
    public EmbeddedBinaryDirective(Configuration config, OutputStream outputStream) {
        super(config, outputStream);
    }

    @Override
    public void writeBytes(int startAddress, Line line) throws IOException {
        if (this.parameters.size() != 2) {
            throw new IllegalArgumentException("$embed requires a name and address parameter");
        }
        String filename = this.requiresString();
        int targetAddress = this.requiresInteger();
        File file = new File(this.config.sourceFile.getParentFile(), filename);
        byte[] bin = Files.readAllBytes(file.toPath());
        Optional<Line> nextLine = line.nextLine();
        byte[] basicCode = nextLine.isPresent() ? this.callAndGoto(startAddress, nextLine.get()) : this.callAndReturn(startAddress);
        int moveLength = 29;
        int embeddedStart = startAddress + basicCode.length + 29;
        int embeddedEnd = embeddedStart + bin.length;
        this.outputStream.write(basicCode);
        this.setAddress(embeddedStart, 60);
        this.setAddress(embeddedEnd, 62);
        this.setAddress(targetAddress, 66);
        this.ldy(0);
        this.jmp(65068);
        this.outputStream.write(bin);
    }

    private byte[] callAndGoto(int startAddress, Line line) throws IOException {
        int tokenCount = 4;
        int offset = Integer.toString(line.lineNumber).length() + 4;
        if (startAddress < 10000 && startAddress + (offset += Integer.toString(startAddress).length()) >= 10000) {
            ++offset;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write(ApplesoftKeyword.CALL.code);
        os.write(Integer.toString(startAddress + offset).getBytes());
        os.write(58);
        os.write(ApplesoftKeyword.GOTO.code);
        os.write(Integer.toString(line.lineNumber).getBytes());
        os.write(0);
        return os.toByteArray();
    }

    private byte[] callAndReturn(int startAddress) throws IOException {
        int tokenCount = 4;
        int offset = 4;
        if (startAddress < 10000 && startAddress + (offset += Integer.toString(startAddress).length()) >= 10000) {
            ++offset;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write(ApplesoftKeyword.CALL.code);
        os.write(Integer.toString(startAddress + offset).getBytes());
        os.write(58);
        os.write(ApplesoftKeyword.RETURN.code);
        os.write(0);
        return os.toByteArray();
    }
}

