/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastokenizer.api;

import io.github.applecommander.bastokenizer.api.Configuration;
import io.github.applecommander.bastokenizer.api.Visitor;
import io.github.applecommander.bastokenizer.api.visitors.ByteVisitor;
import io.github.applecommander.bastokenizer.api.visitors.LineNumberTargetCollector;
import io.github.applecommander.bastokenizer.api.visitors.PrettyPrintVisitor;
import io.github.applecommander.bastokenizer.api.visitors.PrintVisitor;
import io.github.applecommander.bastokenizer.api.visitors.ReassignmentVisitor;
import io.github.applecommander.bastokenizer.api.visitors.VariableReportVisitor;
import java.io.PrintStream;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class Visitors {
    public static PrintBuilder printBuilder() {
        return new PrintBuilder();
    }

    public static ByteVisitor byteVisitor(Configuration config) {
        return new ByteVisitor(config);
    }

    public static ReassignmentVisitor reassignVisitor(Map<Integer, Integer> reassignments) {
        return new ReassignmentVisitor(reassignments);
    }

    public static LineNumberTargetCollector lineNumberTargetCollector() {
        return new LineNumberTargetCollector();
    }

    public static Visitor variableReportVisitor() {
        return new VariableReportVisitor();
    }

    public static class PrintBuilder {
        private PrintStream printStream = System.out;
        private Function<PrintBuilder, Visitor> creator = PrintVisitor::new;

        public PrintBuilder printStream(PrintStream printStream) {
            Objects.requireNonNull(printStream);
            this.printStream = printStream;
            return this;
        }

        public PrintBuilder prettyPrint(boolean flag) {
            this.creator = flag ? PrettyPrintVisitor::new : PrintVisitor::new;
            return this;
        }

        public PrintBuilder prettyPrint() {
            this.creator = PrettyPrintVisitor::new;
            return this;
        }

        public PrintBuilder print() {
            this.creator = PrintVisitor::new;
            return this;
        }

        public Visitor build() {
            return this.creator.apply(this);
        }

        public PrintStream getPrintStream() {
            return this.printStream;
        }
    }
}

