/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastokenizer.api;

import io.github.applecommander.bastokenizer.api.model.Line;
import io.github.applecommander.bastokenizer.api.model.Program;
import io.github.applecommander.bastokenizer.api.model.Statement;
import io.github.applecommander.bastokenizer.api.model.Token;
import java.util.Objects;
import java.util.Queue;

public class Parser {
    private final Queue<Token> tokens;

    public Parser(Queue<Token> tokens) {
        Objects.requireNonNull(tokens);
        this.tokens = tokens;
    }

    public Program parse() {
        Program program = new Program();
        while (!this.tokens.isEmpty()) {
            Line line = this.readLine(program);
            program.lines.add(line);
        }
        return program;
    }

    public Line readLine(Program program) {
        Statement statement;
        Line line = new Line(this.expectNumber(), program);
        while (!this.tokens.isEmpty() && this.tokens.peek().type != Token.Type.EOL && (statement = this.readStatement()) != null) {
            line.statements.add(statement);
        }
        if (!this.tokens.isEmpty() && this.tokens.peek().type == Token.Type.EOL) {
            this.tokens.remove();
        }
        return line;
    }

    public Statement readStatement() {
        Statement statement = new Statement();
        while (!this.tokens.isEmpty() && this.tokens.peek().type != Token.Type.EOL) {
            Token t = this.tokens.remove();
            if (t.type == Token.Type.SYNTAX && ":".equals(t.text)) break;
            statement.tokens.add(t);
        }
        return statement;
    }

    public int expectNumber() {
        Token c = this.tokens.remove();
        while (c.type == Token.Type.EOL) {
            c = this.tokens.remove();
        }
        if (c.type != Token.Type.NUMBER) {
            throw new RuntimeException("Expected a number in line #" + c.line);
        }
        return c.number.intValue();
    }
}

