/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastokenizer.api;

import io.github.applecommander.bastokenizer.api.Configuration;
import io.github.applecommander.bastokenizer.api.Visitor;
import io.github.applecommander.bastokenizer.api.optimizations.MergeLines;
import io.github.applecommander.bastokenizer.api.optimizations.RemoveEmptyStatements;
import io.github.applecommander.bastokenizer.api.optimizations.RemoveRemStatements;
import io.github.applecommander.bastokenizer.api.optimizations.Renumber;
import java.util.function.Function;

public enum Optimization {
    REMOVE_EMPTY_STATEMENTS(config -> new RemoveEmptyStatements()),
    REMOVE_REM_STATEMENTS(config -> new RemoveRemStatements()),
    MERGE_LINES(config -> new MergeLines((Configuration)config)),
    RENUMBER(config -> new Renumber());

    private Function<Configuration, Visitor> factory;

    private Optimization(Function<Configuration, Visitor> factory) {
        this.factory = factory;
    }

    public Visitor create(Configuration config) {
        return this.factory.apply(config);
    }
}

