/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastokenizer.api;

import io.github.applecommander.bastokenizer.api.Configuration;
import io.github.applecommander.bastokenizer.api.Directive;
import io.github.applecommander.bastokenizer.api.directives.EmbeddedBinaryDirective;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.TreeMap;

public class Directives {
    private static Map<String, Class<? extends Directive>> DIRECTIVES = new TreeMap<String, Class<? extends Directive>>(String.CASE_INSENSITIVE_ORDER){
        private static final long serialVersionUID = -8111460701487331592L;
        {
            this.put("$embed", EmbeddedBinaryDirective.class);
        }
    };

    private Directives() {
    }

    public static Directive find(String text, Configuration config, OutputStream outputStream) {
        if (DIRECTIVES.containsKey(text)) {
            try {
                Class<? extends Directive> clazz = DIRECTIVES.get(text);
                Constructor<? extends Directive> constructor = clazz.getConstructor(Configuration.class, OutputStream.class);
                return constructor.newInstance(config, outputStream);
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
                throw new IllegalArgumentException(String.format("Unable to construct directive '%s'", text), e);
            }
        }
        throw new IllegalArgumentException(String.format("Unable to find directive '%s'", text));
    }
}

