/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastokenizer.api;

import io.github.applecommander.bastokenizer.api.Configuration;
import io.github.applecommander.bastokenizer.api.model.Line;
import io.github.applecommander.bastokenizer.api.model.Token;
import io.github.applecommander.bastokenizer.api.utils.Converters;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class Directive {
    protected Configuration config;
    protected OutputStream outputStream;
    protected List<Token> parameters = new ArrayList<Token>();

    protected Directive(Configuration config, OutputStream outputStream) {
        Objects.requireNonNull(config);
        Objects.requireNonNull(outputStream);
        this.config = config;
        this.outputStream = outputStream;
    }

    public void append(Token token) {
        if (token.type == Token.Type.SYNTAX && ",".equals(token.text)) {
            return;
        }
        this.parameters.add(token);
    }

    protected Token require(Token.Type ... types) {
        Token t = this.parameters.remove(0);
        boolean matches = false;
        for (Token.Type type : types) {
            matches |= type == t.type;
        }
        if (!matches) {
            throw new IllegalArgumentException("Expecting a type of " + types);
        }
        return t;
    }

    protected String requiresString() {
        Token t = this.require(Token.Type.STRING);
        return t.text;
    }

    protected int requiresInteger() {
        Token t = this.require(Token.Type.NUMBER, Token.Type.STRING);
        if (t.type == Token.Type.NUMBER) {
            return t.number.intValue();
        }
        return Converters.toInteger(t.text);
    }

    protected void ldy(int value) throws IOException {
        this.outputStream.write(160);
        this.outputStream.write(value);
    }

    protected void jmp(int address) throws IOException {
        this.outputStream.write(76);
        this.outputStream.write(address & 0xFF);
        this.outputStream.write(address >> 8);
    }

    protected void lda(int value) throws IOException {
        this.outputStream.write(169);
        this.outputStream.write(value);
    }

    protected void sta(int address) throws IOException {
        if ((address & 0xFF00) != 0) {
            throw new RuntimeException("sta does not handle 16 bit addresses yet!");
        }
        this.outputStream.write(133);
        this.outputStream.write(address);
    }

    protected void setAddress(int value, int address) throws IOException {
        this.lda(value & 0xFF);
        this.sta(address);
        this.lda(value >> 8);
        this.sta(address + 1);
    }

    public abstract void writeBytes(int var1, Line var2) throws IOException;
}

