/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.applesingle;

import io.github.applecommander.applesingle.Entry;
import io.github.applecommander.applesingle.EntryType;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ProdosFileInfo {
    public static final int BYTES = 8;
    int access;
    int fileType;
    int auxType;

    public static ProdosFileInfo standardBIN() {
        return new ProdosFileInfo(195, 6, 0);
    }

    public static ProdosFileInfo fromEntry(Entry entry) {
        ByteBuffer infoData = entry.getBuffer();
        short access = infoData.getShort();
        short fileType = infoData.getShort();
        int auxType = infoData.getInt();
        return new ProdosFileInfo(access, fileType, auxType);
    }

    public ProdosFileInfo(int access, int fileType, int auxType) {
        this.access = access;
        this.fileType = fileType;
        this.auxType = auxType;
    }

    public Entry toEntry() {
        ByteBuffer buf = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN);
        buf.putShort((short)this.access);
        buf.putShort((short)this.fileType);
        buf.putInt(this.auxType);
        return Entry.create(EntryType.PRODOS_FILE_INFO, buf.array());
    }

    public int getAccess() {
        return this.access;
    }

    public int getFileType() {
        return this.fileType;
    }

    public int getAuxType() {
        return this.auxType;
    }
}

