/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.applesingle;

import io.github.applecommander.applesingle.Entry;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import java.util.function.Consumer;

public final class AppleSingleReader {
    private byte[] data;
    private int pos = 0;
    private Consumer<Integer> versionReporter = v -> {};
    private Consumer<Integer> numberOfEntriesReporter = n -> {};
    private Consumer<Entry> entryReporter = e -> {};
    private ReadAtReporter readAtReporter = (s, b, d) -> {};

    private AppleSingleReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer read(int len, String description) {
        try {
            ByteBuffer byteBuffer = this.readAt(this.pos, len, description);
            return byteBuffer;
        }
        finally {
            this.pos += len;
        }
    }

    public ByteBuffer readAt(int start, int len, String description) {
        byte[] chunk = new byte[len];
        System.arraycopy(this.data, start, chunk, 0, len);
        this.readAtReporter.accept(start, chunk, description);
        ByteBuffer buffer = ByteBuffer.wrap(chunk).order(ByteOrder.BIG_ENDIAN);
        return buffer;
    }

    public void reportVersion(int version) {
        this.versionReporter.accept(version);
    }

    public void reportNumberOfEntries(int numberOfEntries) {
        this.numberOfEntriesReporter.accept(numberOfEntries);
    }

    public void reportEntry(Entry entry) {
        this.entryReporter.accept(entry);
    }

    public static Builder builder(byte[] data) {
        return new Builder(data);
    }

    static /* synthetic */ byte[] access$202(AppleSingleReader x0, byte[] x1) {
        x0.data = x1;
        return x1;
    }

    public static interface ReadAtReporter {
        public void accept(int var1, byte[] var2, String var3);

        default public ReadAtReporter andThen(ReadAtReporter after) {
            Objects.requireNonNull(after);
            return (s, b, d) -> {
                this.accept(s, b, d);
                after.accept(s, b, d);
            };
        }
    }

    public static class Builder {
        private AppleSingleReader reader = new AppleSingleReader();

        private Builder(byte[] data) {
            Objects.requireNonNull(data, "You must supply a byte[] of data");
            AppleSingleReader.access$202(this.reader, data);
        }

        public Builder versionReporter(Consumer<Integer> consumer) {
            Objects.requireNonNull(consumer);
            this.reader.versionReporter = this.reader.versionReporter.andThen(consumer);
            return this;
        }

        public Builder numberOfEntriesReporter(Consumer<Integer> consumer) {
            Objects.requireNonNull(consumer);
            this.reader.numberOfEntriesReporter = this.reader.numberOfEntriesReporter.andThen(consumer);
            return this;
        }

        public Builder entryReporter(Consumer<Entry> consumer) {
            Objects.requireNonNull(consumer);
            this.reader.entryReporter = this.reader.entryReporter.andThen(consumer);
            return this;
        }

        public Builder readAtReporter(ReadAtReporter consumer) {
            Objects.requireNonNull(consumer);
            this.reader.readAtReporter = this.reader.readAtReporter.andThen(consumer);
            return this;
        }

        public AppleSingleReader build() {
            return this.reader;
        }
    }
}

