/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.applesingle;

import io.github.applecommander.applesingle.AppleSingleReader;
import io.github.applecommander.applesingle.Entry;
import io.github.applecommander.applesingle.EntryType;
import io.github.applecommander.applesingle.FileDatesInfo;
import io.github.applecommander.applesingle.ProdosFileInfo;
import io.github.applecommander.applesingle.Utilities;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class AppleSingle {
    public static final int MAGIC_NUMBER = 333312;
    public static final int VERSION_NUMBER1 = 65536;
    public static final int VERSION_NUMBER2 = 131072;
    private Map<Integer, Consumer<Entry>> entryConsumers = new HashMap<Integer, Consumer<Entry>>();
    private byte[] dataFork;
    private byte[] resourceFork;
    private String realName;
    private ProdosFileInfo prodosFileInfo;
    private FileDatesInfo fileDatesInfo;

    private AppleSingle() {
        this.entryConsumers.put(1, entry -> {
            this.dataFork = entry.getData();
        });
        this.entryConsumers.put(2, entry -> {
            this.resourceFork = entry.getData();
        });
        this.entryConsumers.put(3, entry -> {
            this.realName = Utilities.entryToAsciiString(entry);
        });
        this.entryConsumers.put(8, entry -> {
            this.fileDatesInfo = FileDatesInfo.fromEntry(entry);
        });
        this.entryConsumers.put(11, entry -> {
            this.prodosFileInfo = ProdosFileInfo.fromEntry(entry);
        });
        this.prodosFileInfo = ProdosFileInfo.standardBIN();
        this.fileDatesInfo = new FileDatesInfo();
    }

    private AppleSingle(List<Entry> entries) throws IOException {
        this.entryConsumers.put(1, entry -> {
            this.dataFork = entry.getData();
        });
        this.entryConsumers.put(2, entry -> {
            this.resourceFork = entry.getData();
        });
        this.entryConsumers.put(3, entry -> {
            this.realName = Utilities.entryToAsciiString(entry);
        });
        this.entryConsumers.put(8, entry -> {
            this.fileDatesInfo = FileDatesInfo.fromEntry(entry);
        });
        this.entryConsumers.put(11, entry -> {
            this.prodosFileInfo = ProdosFileInfo.fromEntry(entry);
        });
        this.prodosFileInfo = ProdosFileInfo.standardBIN();
        this.fileDatesInfo = new FileDatesInfo();
        entries.forEach(entry -> Optional.ofNullable(entry).map(Entry::getEntryId).map(this.entryConsumers::get).ifPresent(c -> c.accept(entry)));
    }

    public byte[] getDataFork() {
        return this.dataFork;
    }

    public byte[] getResourceFork() {
        return this.resourceFork;
    }

    public String getRealName() {
        return this.realName;
    }

    public ProdosFileInfo getProdosFileInfo() {
        return this.prodosFileInfo;
    }

    public FileDatesInfo getFileDatesInfo() {
        return this.fileDatesInfo;
    }

    public void save(OutputStream outputStream) throws IOException {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        Optional.ofNullable(this.realName).map(String::getBytes).map(b -> Entry.create(EntryType.REAL_NAME, b)).ifPresent(entries::add);
        Optional.ofNullable(this.prodosFileInfo).map(ProdosFileInfo::toEntry).ifPresent(entries::add);
        Optional.ofNullable(this.fileDatesInfo).map(FileDatesInfo::toEntry).ifPresent(entries::add);
        Optional.ofNullable(this.resourceFork).map(b -> Entry.create(EntryType.RESOURCE_FORK, b)).ifPresent(entries::add);
        Optional.ofNullable(this.dataFork).map(b -> Entry.create(EntryType.DATA_FORK, b)).ifPresent(entries::add);
        AppleSingle.write(outputStream, entries);
    }

    public void save(File file) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            this.save(outputStream);
        }
    }

    public void save(Path path) throws IOException {
        try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
            this.save(outputStream);
        }
    }

    public static void write(OutputStream outputStream, List<Entry> entries) throws IOException {
        byte[] filler = new byte[16];
        ByteBuffer buf = ByteBuffer.allocate(26).order(ByteOrder.BIG_ENDIAN);
        buf.putInt(333312);
        buf.putInt(131072);
        buf.put(filler);
        buf.putShort((short)entries.size());
        outputStream.write(buf.array());
        int offset = 26 + 12 * entries.size();
        for (Entry entry : entries) {
            entry.writeHeader(outputStream, offset);
            offset += entry.getLength();
        }
        for (Entry entry : entries) {
            entry.writeData(outputStream);
        }
    }

    public static AppleSingle read(InputStream inputStream) throws IOException {
        Objects.requireNonNull(inputStream, "Please supply an input stream");
        return AppleSingle.read(Utilities.toByteArray(inputStream));
    }

    public static AppleSingle read(File file) throws IOException {
        Objects.requireNonNull(file, "Please supply a file");
        return AppleSingle.read(file.toPath());
    }

    public static AppleSingle read(Path path) throws IOException {
        Objects.requireNonNull(path, "Please supply a file");
        return AppleSingle.read(Files.readAllBytes(path));
    }

    public static AppleSingle read(byte[] data) throws IOException {
        Objects.requireNonNull(data);
        return new AppleSingle(AppleSingle.asEntries(data));
    }

    public static List<Entry> asEntries(InputStream inputStream) throws IOException {
        Objects.requireNonNull(inputStream);
        return AppleSingle.asEntries(Utilities.toByteArray(inputStream));
    }

    public static List<Entry> asEntries(File file) throws IOException {
        Objects.requireNonNull(file);
        return AppleSingle.asEntries(file.toPath());
    }

    public static List<Entry> asEntries(Path path) throws IOException {
        Objects.requireNonNull(path);
        return AppleSingle.asEntries(Files.readAllBytes(path));
    }

    public static List<Entry> asEntries(byte[] data) throws IOException {
        Objects.requireNonNull(data);
        return AppleSingle.asEntries(AppleSingleReader.builder(data).build());
    }

    public static List<Entry> asEntries(AppleSingleReader reader) throws IOException {
        Objects.requireNonNull(reader);
        ArrayList<Entry> entries = new ArrayList<Entry>();
        AppleSingle.required(reader, "Magic number", "Not an AppleSingle file - magic number does not match.", 333312);
        int version = AppleSingle.required(reader, "Version", "Only AppleSingle version 1 and 2 supported.", 65536, 131072);
        reader.reportVersion(version);
        reader.read(16, "Filler");
        int numberOfEntries = reader.read(2, "Number of entries").getShort();
        reader.reportNumberOfEntries(numberOfEntries);
        for (int i = 0; i < numberOfEntries; ++i) {
            Entry entry = Entry.create(reader);
            entries.add(entry);
            reader.reportEntry(entry);
        }
        return entries;
    }

    private static int required(AppleSingleReader reader, String description, String message, int ... expecteds) throws IOException {
        int actual = reader.read(4, description).getInt();
        for (int expected : expecteds) {
            if (actual != expected) continue;
            return actual;
        }
        ArrayList<String> versions = new ArrayList<String>();
        for (int expected : expecteds) {
            versions.add(String.format("0x%08x", expected));
        }
        throw new IOException(String.format("%s  Expected %s but read 0x%08x.", message, String.join((CharSequence)",", versions), actual));
    }

    public static Builder builder() {
        return new Builder();
    }

    static /* synthetic */ byte[] access$202(AppleSingle x0, byte[] x1) {
        x0.dataFork = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$302(AppleSingle x0, byte[] x1) {
        x0.resourceFork = x1;
        return x1;
    }

    public static class Builder {
        private AppleSingle as = new AppleSingle();

        public Builder realName(String realName) {
            if (!Character.isAlphabetic(realName.charAt(0))) {
                throw new IllegalArgumentException("ProDOS file names must begin with a letter");
            }
            this.as.realName = realName.chars().map(this::sanitize).limit(15L).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
            return this;
        }

        private int sanitize(int ch) {
            if (Character.isAlphabetic(ch) || Character.isDigit(ch)) {
                return Character.toUpperCase(ch);
            }
            return 46;
        }

        public Builder dataFork(byte[] dataFork) {
            AppleSingle.access$202(this.as, dataFork);
            return this;
        }

        public Builder resourceFork(byte[] resourceFork) {
            AppleSingle.access$302(this.as, resourceFork);
            return this;
        }

        public Builder access(int access) {
            ((AppleSingle)this.as).prodosFileInfo.access = access;
            return this;
        }

        public Builder fileType(int fileType) {
            ((AppleSingle)this.as).prodosFileInfo.fileType = fileType;
            return this;
        }

        public Builder auxType(int auxType) {
            ((AppleSingle)this.as).prodosFileInfo.auxType = auxType;
            return this;
        }

        public Builder creationDate(int creation) {
            ((AppleSingle)this.as).fileDatesInfo.creation = creation;
            return this;
        }

        public Builder creationDate(Instant creation) {
            ((AppleSingle)this.as).fileDatesInfo.creation = FileDatesInfo.fromInstant(creation);
            return this;
        }

        public Builder modificationDate(int modification) {
            ((AppleSingle)this.as).fileDatesInfo.modification = modification;
            return this;
        }

        public Builder modificationDate(Instant modification) {
            ((AppleSingle)this.as).fileDatesInfo.modification = FileDatesInfo.fromInstant(modification);
            return this;
        }

        public Builder backupDate(int backup) {
            ((AppleSingle)this.as).fileDatesInfo.backup = backup;
            return this;
        }

        public Builder backupDate(Instant backup) {
            ((AppleSingle)this.as).fileDatesInfo.backup = FileDatesInfo.fromInstant(backup);
            return this;
        }

        public Builder accessDate(int access) {
            ((AppleSingle)this.as).fileDatesInfo.access = access;
            return this;
        }

        public Builder accessDate(Instant access) {
            ((AppleSingle)this.as).fileDatesInfo.access = FileDatesInfo.fromInstant(access);
            return this;
        }

        public Builder allDates(Instant instant) {
            return this.creationDate(instant).modificationDate(instant).backupDate(instant).accessDate(instant);
        }

        public AppleSingle build() {
            return this.as;
        }
    }
}

