/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.applesingle;

import java.time.Instant;
import java.util.function.IntSupplier;

public class FileDatesInfo {
    public static final Instant EPOCH_INSTANT = Instant.parse("2000-01-01T00:00:00.00Z");
    public static final int UNKNOWN_DATE = Integer.MIN_VALUE;
    int creation;
    int modification;
    int backup;
    int access;

    public static int fromInstant(Instant instant) {
        return (int)(instant.getEpochSecond() - EPOCH_INSTANT.getEpochSecond());
    }

    public FileDatesInfo() {
        int current;
        this.creation = current = FileDatesInfo.fromInstant(Instant.now());
        this.modification = current;
        this.backup = current;
        this.access = current;
    }

    public FileDatesInfo(int creation, int modification, int backup, int access) {
        this.creation = creation;
        this.modification = modification;
        this.backup = backup;
        this.access = access;
    }

    public Instant getCreationInstant() {
        return this.toInstant(this::getCreation);
    }

    public Instant getModificationInstant() {
        return this.toInstant(this::getModification);
    }

    public Instant getBackupInstant() {
        return this.toInstant(this::getBackup);
    }

    public Instant getAccessInstant() {
        return this.toInstant(this::getAccess);
    }

    public Instant toInstant(IntSupplier timeSupplier) {
        return Instant.ofEpochSecond((long)timeSupplier.getAsInt() + EPOCH_INSTANT.getEpochSecond());
    }

    public int getCreation() {
        return this.creation;
    }

    public int getModification() {
        return this.modification;
    }

    public int getBackup() {
        return this.backup;
    }

    public int getAccess() {
        return this.access;
    }
}

