/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.applesingle;

import io.github.applecommander.applesingle.ProdosFileInfo;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class AppleSingle {
    public static final int MAGIC_NUMBER = 333312;
    public static final int VERSION_NUMBER = 131072;
    private Map<Integer, Consumer<byte[]>> entryConsumers = new HashMap<Integer, Consumer<byte[]>>();
    private byte[] dataFork;
    private byte[] resourceFork;
    private String realName;
    private ProdosFileInfo prodosFileInfo;

    private AppleSingle() {
        this.entryConsumers.put(1, this::setDataFork);
        this.entryConsumers.put(2, this::setResourceFork);
        this.entryConsumers.put(3, this::setRealName);
        this.entryConsumers.put(11, this::setProdosFileInfo);
        this.prodosFileInfo = ProdosFileInfo.standardBIN();
    }

    private AppleSingle(byte[] data) throws IOException {
        this.entryConsumers.put(1, this::setDataFork);
        this.entryConsumers.put(2, this::setResourceFork);
        this.entryConsumers.put(3, this::setRealName);
        this.entryConsumers.put(11, this::setProdosFileInfo);
        this.prodosFileInfo = ProdosFileInfo.standardBIN();
        ByteBuffer buffer = ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN).asReadOnlyBuffer();
        this.required(buffer, 333312, "Not an AppleSingle file - magic number does not match.");
        this.required(buffer, 131072, "Only AppleSingle version 2 supported.");
        buffer.position(buffer.position() + 16);
        int entries = buffer.getShort();
        for (int i = 0; i < entries; ++i) {
            int entryId = buffer.getInt();
            int offset = buffer.getInt();
            int length = buffer.getInt();
            buffer.mark();
            buffer.position(offset);
            byte[] entryData = new byte[length];
            buffer.get(entryData);
            Optional.ofNullable(this.entryConsumers.get(entryId)).orElseThrow(() -> new IOException(String.format("Unknown entry type of %04X", entryId))).accept(entryData);
            buffer.reset();
        }
    }

    private void required(ByteBuffer buffer, int expected, String message) throws IOException {
        int actual = buffer.getInt();
        if (actual != expected) {
            throw new IOException(String.format("%s  Expected 0x%08x but read 0x%08x.", message, expected, actual));
        }
    }

    private void setDataFork(byte[] entryData) {
        this.dataFork = entryData;
    }

    private void setResourceFork(byte[] entryData) {
        this.resourceFork = entryData;
    }

    private void setRealName(byte[] entryData) {
        for (int i = 0; i < entryData.length; ++i) {
            entryData[i] = (byte)(entryData[i] & 0x7F);
        }
        this.realName = new String(entryData);
    }

    private void setProdosFileInfo(byte[] entryData) {
        ByteBuffer infoData = ByteBuffer.wrap(entryData).order(ByteOrder.BIG_ENDIAN).asReadOnlyBuffer();
        short access = infoData.getShort();
        short fileType = infoData.getShort();
        int auxType = infoData.getInt();
        this.prodosFileInfo = new ProdosFileInfo(access, fileType, auxType);
    }

    public byte[] getDataFork() {
        return this.dataFork;
    }

    public byte[] getResourceFork() {
        return this.resourceFork;
    }

    public String getRealName() {
        return this.realName;
    }

    public ProdosFileInfo getProdosFileInfo() {
        return this.prodosFileInfo;
    }

    public void save(OutputStream outputStream) throws IOException {
        boolean hasResourceFork = this.resourceFork != null;
        boolean hasRealName = this.realName != null;
        int entries = 2 + (hasRealName ? 1 : 0) + (hasResourceFork ? 1 : 0);
        int realNameOffset = 26 + 12 * entries;
        int prodosFileInfoOffset = realNameOffset + (hasRealName ? this.realName.length() : 0);
        int resourceForkOffset = prodosFileInfoOffset + 8;
        int dataForkOffset = resourceForkOffset + (hasResourceFork ? this.resourceFork.length : 0);
        this.writeFileHeader(outputStream, entries);
        if (hasRealName) {
            this.writeHeader(outputStream, 3, realNameOffset, this.realName.length());
        }
        this.writeHeader(outputStream, 11, prodosFileInfoOffset, 8);
        if (hasResourceFork) {
            this.writeHeader(outputStream, 2, resourceForkOffset, this.resourceFork.length);
        }
        this.writeHeader(outputStream, 1, dataForkOffset, this.dataFork.length);
        if (hasRealName) {
            this.writeRealName(outputStream);
        }
        this.writeProdosFileInfo(outputStream);
        if (hasResourceFork) {
            this.writeResourceFork(outputStream);
        }
        this.writeDataFork(outputStream);
    }

    public void save(File file) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            this.save(outputStream);
        }
    }

    public void save(Path path) throws IOException {
        try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
            this.save(outputStream);
        }
    }

    private void writeFileHeader(OutputStream outputStream, int numberOfEntries) throws IOException {
        byte[] filler = new byte[16];
        ByteBuffer buf = ByteBuffer.allocate(26).order(ByteOrder.BIG_ENDIAN);
        buf.putInt(333312);
        buf.putInt(131072);
        buf.put(filler);
        buf.putShort((short)numberOfEntries);
        outputStream.write(buf.array());
    }

    private void writeHeader(OutputStream outputStream, int entryId, int offset, int length) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(12).order(ByteOrder.BIG_ENDIAN);
        buf.putInt(entryId);
        buf.putInt(offset);
        buf.putInt(length);
        outputStream.write(buf.array());
    }

    private void writeRealName(OutputStream outputStream) throws IOException {
        outputStream.write(this.realName.getBytes());
    }

    private void writeProdosFileInfo(OutputStream outputStream) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN);
        buf.putShort((short)this.prodosFileInfo.access);
        buf.putShort((short)this.prodosFileInfo.fileType);
        buf.putInt(this.prodosFileInfo.auxType);
        outputStream.write(buf.array());
    }

    private void writeResourceFork(OutputStream outputStream) throws IOException {
        outputStream.write(this.resourceFork);
    }

    private void writeDataFork(OutputStream outputStream) throws IOException {
        outputStream.write(this.dataFork);
    }

    public static AppleSingle read(InputStream inputStream) throws IOException {
        Objects.requireNonNull(inputStream, "Please supply an input stream");
        return AppleSingle.read(AppleSingle.toByteArray(inputStream));
    }

    public static AppleSingle read(File file) throws IOException {
        Objects.requireNonNull(file, "Please supply a file");
        return AppleSingle.read(file.toPath());
    }

    public static AppleSingle read(Path path) throws IOException {
        Objects.requireNonNull(path, "Please supply a file");
        return new AppleSingle(Files.readAllBytes(path));
    }

    public static AppleSingle read(byte[] data) throws IOException {
        Objects.requireNonNull(data);
        return new AppleSingle(data);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        byte[] buf;
        int len;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        while ((len = inputStream.read(buf = new byte[1024])) != -1) {
            outputStream.write(buf, 0, len);
        }
        outputStream.flush();
        return outputStream.toByteArray();
    }

    static /* synthetic */ byte[] access$202(AppleSingle x0, byte[] x1) {
        x0.dataFork = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$302(AppleSingle x0, byte[] x1) {
        x0.resourceFork = x1;
        return x1;
    }

    public static class Builder {
        private AppleSingle as = new AppleSingle();

        public Builder realName(String realName) {
            if (!Character.isAlphabetic(realName.charAt(0))) {
                throw new IllegalArgumentException("ProDOS file names must begin with a letter");
            }
            this.as.realName = realName.chars().map(this::sanitize).limit(15L).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
            return this;
        }

        private int sanitize(int ch) {
            if (Character.isAlphabetic(ch) || Character.isDigit(ch)) {
                return Character.toUpperCase(ch);
            }
            return 46;
        }

        public Builder dataFork(byte[] dataFork) {
            AppleSingle.access$202(this.as, dataFork);
            return this;
        }

        public Builder resourceFork(byte[] resourceFork) {
            AppleSingle.access$302(this.as, resourceFork);
            return this;
        }

        public Builder access(int access) {
            ((AppleSingle)this.as).prodosFileInfo.access = access;
            return this;
        }

        public Builder fileType(int fileType) {
            ((AppleSingle)this.as).prodosFileInfo.fileType = fileType;
            return this;
        }

        public Builder auxType(int auxType) {
            ((AppleSingle)this.as).prodosFileInfo.auxType = auxType;
            return this;
        }

        public AppleSingle build() {
            return this.as;
        }
    }
}

