/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.shrinkit.io;

import java.io.IOException;
import java.io.OutputStream;

public class RleOutputStream
extends OutputStream {
    private OutputStream os;
    private int escapeChar;
    private int repeatedByte;
    private int numBytes = -1;

    public RleOutputStream(OutputStream bs) {
        this(bs, 219);
    }

    public RleOutputStream(OutputStream os, int escapeChar) {
        this.os = os;
        this.escapeChar = escapeChar;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.numBytes == -1) {
            this.repeatedByte = b;
            ++this.numBytes;
        } else if (this.repeatedByte == b) {
            ++this.numBytes;
            if (this.numBytes > 255) {
                this.flush();
            }
        } else {
            this.flush();
            this.repeatedByte = b;
            ++this.numBytes;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.numBytes != -1) {
            if (this.numBytes == 0 && this.escapeChar != this.repeatedByte) {
                this.os.write(this.repeatedByte);
            } else {
                this.os.write(this.escapeChar);
                this.os.write(this.repeatedByte);
                this.os.write(this.numBytes);
            }
            this.numBytes = -1;
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.os.close();
    }
}

