/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.shrinkit;

import com.webcodepro.shrinkit.HeaderBlock;
import com.webcodepro.shrinkit.NuFileArchive;
import com.webcodepro.shrinkit.ThreadClass;
import com.webcodepro.shrinkit.ThreadFormat;
import com.webcodepro.shrinkit.ThreadKind;
import com.webcodepro.shrinkit.ThreadRecord;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;

public class NufxScan {
    private static File archiveWithSmallestCompressedFile;
    private static String smallestCompressedFilename;
    private static long sizeOfSmallestCompressedFile;

    public static void main(String[] args) throws IOException {
        for (String dir : args) {
            NufxScan.scanDirectory(dir);
        }
    }

    private static void scanDirectory(String dirName) throws IOException {
        File dir = new File(dirName);
        NufxScan.scanDirectory(dir);
    }

    private static void scanDirectory(File directory) throws IOException {
        File[] files;
        System.out.printf("Scanning '%s'...\n", directory.toString());
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("'" + directory.toString() + "' is not a directory");
        }
        for (File file : files = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                boolean isSHK = file.getName().toLowerCase().endsWith(".shk");
                boolean isSDK = file.getName().toLowerCase().endsWith(".sdk");
                boolean isDirectory = file.isDirectory();
                boolean keep = isSHK || isSDK || isDirectory;
                return keep;
            }
        })) {
            if (file.isDirectory()) {
                NufxScan.scanDirectory(file);
                continue;
            }
            NufxScan.displayArchive(file);
        }
        if (sizeOfSmallestCompressedFile != 0L) {
            System.out.printf("\n\nSmallest compressed file:\n", new Object[0]);
            System.out.printf("Archive = %s\n", archiveWithSmallestCompressedFile.getAbsoluteFile());
            System.out.printf("Filename = %s\n", smallestCompressedFilename);
            System.out.printf("Size = %08x (%d)\n", sizeOfSmallestCompressedFile, sizeOfSmallestCompressedFile);
        }
    }

    private static void displayArchive(File archive) throws IOException {
        System.out.printf("Details for %s\n\n", archive.getAbsoluteFile());
        try (FileInputStream is = new FileInputStream(archive);){
            NuFileArchive a = new NuFileArchive(is);
            System.out.println("Ver# Threads  FSId FSIn Access   FileType ExtraTyp Stor Thread Formats..... OrigSize CompSize Filename");
            System.out.println("==== ======== ==== ==== ======== ======== ======== ==== =================== ======== ======== ==============================");
            for (HeaderBlock b : a.getHeaderBlocks()) {
                System.out.printf("%04x %08x %04x %04x %08x %08x %08x %04x ", b.getVersionNumber(), b.getTotalThreads(), b.getFileSysId(), b.getFileSysInfo(), b.getAccess(), b.getFileType(), b.getExtraType(), b.getStorageType());
                int threadsPrinted = 0;
                String filename = b.getFilename();
                long origSize = 0L;
                long compSize = 0L;
                boolean compressed = false;
                for (ThreadRecord r : b.getThreadRecords()) {
                    ++threadsPrinted;
                    System.out.printf("%04x ", r.getThreadFormat().getThreadFormat());
                    compressed |= r.getThreadFormat() != ThreadFormat.UNCOMPRESSED;
                    if (r.getThreadKind() == ThreadKind.FILENAME) {
                        filename = r.getText();
                    }
                    if (r.getThreadClass() != ThreadClass.DATA) continue;
                    origSize += r.getThreadEof();
                    compSize += r.getCompThreadEof();
                }
                while (threadsPrinted < 4) {
                    System.out.printf("     ", new Object[0]);
                    ++threadsPrinted;
                }
                System.out.printf("%08x %08x ", origSize, compSize);
                if (filename == null || filename.length() == 0) {
                    filename = "<Unknown>";
                }
                System.out.println(filename);
                if (!compressed || sizeOfSmallestCompressedFile != 0L && compSize >= sizeOfSmallestCompressedFile) continue;
                sizeOfSmallestCompressedFile = compSize;
                archiveWithSmallestCompressedFile = archive;
                smallestCompressedFilename = filename;
            }
            System.out.println();
        }
    }
}

