/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.shrinkit;

import com.webcodepro.shrinkit.io.ByteConstants;
import com.webcodepro.shrinkit.io.LittleEndianByteInputStream;
import java.io.IOException;
import java.util.Date;

public class MasterHeaderBlock {
    private static final int MASTER_HEADER_LENGTH = 48;
    private int masterCrc;
    private boolean validCrc;
    private long totalRecords;
    private Date archiveCreateWhen;
    private Date archiveModWhen;
    private int masterVersion;
    private long masterEof;

    public MasterHeaderBlock(LittleEndianByteInputStream bs) throws IOException {
        int fileType = 0;
        int headerOffset = 0;
        fileType = bs.seekFileType();
        if (fileType == 3) {
            bs.readBytes(127 - ByteConstants.NUFILE_ID.length);
            headerOffset = 128;
            int count = bs.read();
            if (count != 0) {
                throw new IOException("This is actually a Binary II archive with multiple files in it.");
            }
            fileType = bs.seekFileType();
        }
        if (fileType != 1) {
            throw new IOException("Unable to decode this archive.");
        }
        this.masterCrc = bs.readWord();
        bs.resetCrc();
        this.totalRecords = bs.readLong();
        this.archiveCreateWhen = bs.readDate();
        this.archiveModWhen = bs.readDate();
        this.masterVersion = bs.readWord();
        if (this.masterVersion > 0) {
            bs.readBytes(8);
            this.masterEof = bs.readLong();
        } else {
            this.masterEof = -1L;
        }
        while (bs.getTotalBytesRead() < (long)(48 + headerOffset)) {
            bs.readByte();
        }
        this.validCrc = (long)this.masterCrc == bs.getCrcValue();
    }

    public int getMasterCrc() {
        return this.masterCrc;
    }

    public void setMasterCrc(int masterCrc) {
        this.masterCrc = masterCrc;
    }

    public long getTotalRecords() {
        return this.totalRecords;
    }

    public void setTotalRecords(long totalRecords) {
        this.totalRecords = totalRecords;
    }

    public Date getArchiveCreateWhen() {
        return this.archiveCreateWhen;
    }

    public void setArchiveCreateWhen(Date archiveCreateWhen) {
        this.archiveCreateWhen = archiveCreateWhen;
    }

    public Date getArchiveModWhen() {
        return this.archiveModWhen;
    }

    public void setArchiveModWhen(Date archiveModWhen) {
        this.archiveModWhen = archiveModWhen;
    }

    public int getMasterVersion() {
        return this.masterVersion;
    }

    public void setMasterVersion(int masterVersion) {
        this.masterVersion = masterVersion;
    }

    public long getMasterEof() {
        return this.masterEof;
    }

    public void setMasterEof(long masterEof) {
        this.masterEof = masterEof;
    }

    public boolean isValidCrc() {
        return this.validCrc;
    }
}

