/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.shrinkit;

import com.webcodepro.shrinkit.ThreadClass;
import com.webcodepro.shrinkit.ThreadKind;
import com.webcodepro.shrinkit.ThreadRecord;
import com.webcodepro.shrinkit.io.LittleEndianByteInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class HeaderBlock {
    private int headerCrc;
    private int attribCount;
    private int versionNumber;
    private long totalThreads;
    private int fileSysId;
    private int fileSysInfo;
    private long access;
    private long fileType;
    private long extraType;
    private int storageType;
    private Date createWhen;
    private Date modWhen;
    private Date archiveWhen;
    private int optionSize;
    private byte[] optionListBytes;
    private byte[] attribBytes;
    private String filename;
    private String rawFilename;
    private long headerSize = 0L;
    private List<ThreadRecord> threads = new ArrayList<ThreadRecord>();

    public HeaderBlock(LittleEndianByteInputStream bs) throws IOException {
        int length;
        int type = bs.seekFileType(4);
        if (type == 0) {
            throw new IOException("Unable to decode this archive.");
        }
        this.headerCrc = bs.readWord();
        this.attribCount = bs.readWord();
        this.versionNumber = bs.readWord();
        this.totalThreads = bs.readLong();
        this.fileSysId = bs.readWord();
        this.fileSysInfo = bs.readWord();
        this.access = bs.readLong();
        this.fileType = bs.readLong();
        this.extraType = bs.readLong();
        this.storageType = bs.readWord();
        this.createWhen = bs.readDate();
        this.modWhen = bs.readDate();
        this.archiveWhen = bs.readDate();
        if (this.versionNumber >= 1) {
            this.optionSize = bs.readWord();
            if (this.optionSize > 0) {
                this.optionListBytes = bs.readBytes(this.optionSize - 2);
            }
        }
        int sizeofAttrib = this.attribCount - 58;
        if (this.versionNumber >= 1) {
            sizeofAttrib = this.optionSize == 0 ? (sizeofAttrib -= 2) : (sizeofAttrib -= this.optionSize);
        }
        if (sizeofAttrib > 0) {
            this.attribBytes = bs.readBytes(sizeofAttrib);
        }
        if ((length = bs.readWord()) > 0) {
            this.rawFilename = new String(bs.readBytes(length));
        }
        if (this.rawFilename == null) {
            this.rawFilename = "Unknown";
        }
    }

    public void readThreads(LittleEndianByteInputStream bs) throws IOException {
        for (long l = 0L; l < this.totalThreads; ++l) {
            this.threads.add(new ThreadRecord(this, bs));
        }
        for (ThreadRecord r : this.threads) {
            r.readThreadData(bs);
            this.headerSize += r.getThreadEof();
        }
    }

    public String getFilename() {
        if (this.filename == null) {
            ThreadRecord r = this.findThreadRecord(ThreadKind.FILENAME);
            if (r != null) {
                this.filename = r.getText();
            }
            if (this.filename == null) {
                this.filename = this.rawFilename;
            }
            if (this.filename.contains(":")) {
                this.filename = this.filename.replace(":", "/");
            }
        }
        return this.filename;
    }

    public String getFinalFilename() {
        String filename = this.getFilename();
        String[] path = filename.split("/");
        filename = path[path.length - 1];
        return filename;
    }

    public ThreadRecord getDataForkThreadRecord() {
        ThreadRecord thread = this.findThreadRecord(ThreadKind.DATA_FORK);
        if (thread == null) {
            thread = this.findThreadRecord(ThreadKind.DISK_IMAGE);
        }
        return thread;
    }

    public ThreadRecord getResourceForkThreadRecord() {
        return this.findThreadRecord(ThreadKind.RESOURCE_FORK);
    }

    protected ThreadRecord findThreadRecord(ThreadKind tk) {
        for (ThreadRecord r : this.threads) {
            if (r.getThreadKind() != tk) continue;
            return r;
        }
        return null;
    }

    public String getFileSystemSeparator() {
        switch (this.getFileSysInfo() & 0xFF) {
            case 47: 
            case 175: {
                return "/";
            }
            case 58: 
            case 63: 
            case 186: {
                return ":";
            }
            case 92: 
            case 220: {
                return "\\";
            }
        }
        return "";
    }

    public long getUncompressedSize() {
        long size = 0L;
        for (ThreadRecord r : this.threads) {
            if (r.getThreadClass() != ThreadClass.DATA) continue;
            size += r.getThreadEof();
        }
        return size;
    }

    public long getCompressedSize() {
        long size = 0L;
        for (ThreadRecord r : this.threads) {
            if (r.getThreadClass() != ThreadClass.DATA) continue;
            size += r.getCompThreadEof();
        }
        return size;
    }

    public int getHeaderCrc() {
        return this.headerCrc;
    }

    public void setHeaderCrc(int headerCrc) {
        this.headerCrc = headerCrc;
    }

    public int getAttribCount() {
        return this.attribCount;
    }

    public void setAttribCount(int attribCount) {
        this.attribCount = attribCount;
    }

    public int getVersionNumber() {
        return this.versionNumber;
    }

    public void setVersionNumber(int versionNumber) {
        this.versionNumber = versionNumber;
    }

    public long getTotalThreads() {
        return this.totalThreads;
    }

    public void setTotalThreads(long totalThreads) {
        this.totalThreads = totalThreads;
    }

    public int getFileSysId() {
        return this.fileSysId;
    }

    public void setFileSysId(int fileSysId) {
        this.fileSysId = fileSysId;
    }

    public int getFileSysInfo() {
        return this.fileSysInfo;
    }

    public void setFileSysInfo(int fileSysInfo) {
        this.fileSysInfo = fileSysInfo;
    }

    public long getAccess() {
        return this.access;
    }

    public void setAccess(long access) {
        this.access = access;
    }

    public long getFileType() {
        return this.fileType;
    }

    public void setFileType(long fileType) {
        this.fileType = fileType;
    }

    public long getExtraType() {
        return this.extraType;
    }

    public void setExtraType(long extraType) {
        this.extraType = extraType;
    }

    public int getStorageType() {
        return this.storageType;
    }

    public void setStorageType(int storageType) {
        this.storageType = storageType;
    }

    public Date getCreateWhen() {
        return this.createWhen;
    }

    public void setCreateWhen(Date createWhen) {
        this.createWhen = createWhen;
    }

    public Date getModWhen() {
        return this.modWhen;
    }

    public void setModWhen(Date modWhen) {
        this.modWhen = modWhen;
    }

    public Date getArchiveWhen() {
        return this.archiveWhen;
    }

    public void setArchiveWhen(Date archiveWhen) {
        this.archiveWhen = archiveWhen;
    }

    public int getOptionSize() {
        return this.optionSize;
    }

    public void setOptionSize(int optionSize) {
        this.optionSize = optionSize;
    }

    public byte[] getOptionListBytes() {
        return this.optionListBytes;
    }

    public void setOptionListBytes(byte[] optionListBytes) {
        this.optionListBytes = optionListBytes;
    }

    public byte[] getAttribBytes() {
        return this.attribBytes;
    }

    public void setAttribBytes(byte[] attribBytes) {
        this.attribBytes = attribBytes;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getRawFilename() {
        return this.rawFilename;
    }

    public List<ThreadRecord> getThreadRecords() {
        return this.threads;
    }

    public void setThreadRecords(List<ThreadRecord> threads) {
        this.threads = threads;
    }

    public long getHeaderSize() {
        return this.headerSize;
    }
}

