/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.shrinkit.io;

import com.webcodepro.shrinkit.CRC16;
import com.webcodepro.shrinkit.io.ByteConstants;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;

public class LittleEndianByteInputStream
extends InputStream
implements ByteConstants {
    private InputStream inputStream;
    private long bytesRead = 0L;
    private CRC16 crc = new CRC16();

    public LittleEndianByteInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public LittleEndianByteInputStream(byte[] data) {
        this.inputStream = new ByteArrayInputStream(data);
    }

    @Override
    public int read() throws IOException {
        int b = this.inputStream.read();
        if (b != -1) {
            this.crc.update(b);
            ++this.bytesRead;
        }
        return b;
    }

    public int readByte() throws IOException {
        int i = this.read();
        if (i == -1) {
            throw new IOException("Expecting a byte but at EOF");
        }
        return i;
    }

    public byte[] readBytes(int bytes) throws IOException {
        byte[] data = new byte[bytes];
        int read = this.inputStream.read(data);
        this.bytesRead += (long)read;
        if (bytes == 0 && read == -1) {
            read = 0;
        }
        if (read < bytes) {
            throw new IOException("Requested " + bytes + " bytes, but " + read + " read");
        }
        this.crc.update(data);
        return data;
    }

    public int seekFileType() throws IOException {
        return this.seekFileType(6);
    }

    public int seekFileType(int max) throws IOException {
        int i;
        byte[] data = new byte[2048];
        byte[] testNUFILE = new byte[6];
        byte[] testNUFX = new byte[4];
        byte[] testBXY = new byte[3];
        int type = 0;
        int pos = 0;
        for (i = 0; i < data.length; ++i) {
            data[i] = 0;
        }
        for (i = 0; i < max; ++i) {
            data[i] = (byte)this.readByte();
        }
        while (pos < data.length - max) {
            if (max == 6) {
                System.arraycopy(data, pos, testNUFILE, 0, NUFILE_ID.length);
                if (Arrays.equals(testNUFILE, NUFILE_ID)) {
                    type = 1;
                    break;
                }
            }
            System.arraycopy(data, pos, testNUFX, 0, NUFX_ID.length);
            System.arraycopy(data, pos, testBXY, 0, BXY_ID.length);
            if (Arrays.equals(testNUFX, NUFX_ID)) {
                type = 2;
                break;
            }
            if (Arrays.equals(testBXY, BXY_ID)) {
                type = 3;
                break;
            }
            data[pos + max] = (byte)this.readByte();
            ++pos;
        }
        return type;
    }

    public int readWord() throws IOException {
        return (this.readByte() | this.readByte() << 8) & 0xFFFF;
    }

    public long readLong() throws IOException {
        long a = this.readByte();
        long b = this.readByte();
        long c = this.readByte();
        long d = this.readByte();
        return a | b << 8 | c << 16 | d << 24;
    }

    public Date readDate() throws IOException {
        byte[] data = this.readBytes(8);
        if (Arrays.equals(TIMEREC_NULL, data)) {
            return null;
        }
        int year = data[3] + 1900;
        if (year < 1940) {
            year += 100;
        }
        GregorianCalendar gc = new GregorianCalendar(year, data[5] - 1, data[4], data[2], data[1], data[0]);
        return gc.getTime();
    }

    public void resetCrc() {
        this.crc.reset();
    }

    public long getCrcValue() {
        return this.crc.getValue();
    }

    public long getTotalBytesRead() {
        return this.bytesRead;
    }
}

