/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.shrinkit;

import com.webcodepro.shrinkit.ThreadClass;

public enum ThreadKind {
    ASCII_TEXT,
    ALLOCATED_SPACE,
    APPLE_IIGS_ICON,
    CREATE_DIRECTORY,
    DATA_FORK,
    DISK_IMAGE,
    RESOURCE_FORK,
    FILENAME;


    public static ThreadKind find(int threadKind, ThreadClass threadClass) {
        switch (threadClass) {
            case MESSAGE: {
                switch (threadKind) {
                    case 0: {
                        return ASCII_TEXT;
                    }
                    case 1: {
                        return ALLOCATED_SPACE;
                    }
                    case 2: {
                        return APPLE_IIGS_ICON;
                    }
                }
                throw new IllegalArgumentException("Unknown thread_kind " + threadKind + " for message thread_class of " + (Object)((Object)threadClass));
            }
            case CONTROL: {
                if (threadKind == 0) {
                    return CREATE_DIRECTORY;
                }
                throw new IllegalArgumentException("Unknown thread_kind " + threadKind + " for control thread_class of " + (Object)((Object)threadClass));
            }
            case DATA: {
                switch (threadKind) {
                    case 0: {
                        return DATA_FORK;
                    }
                    case 1: {
                        return DISK_IMAGE;
                    }
                    case 2: {
                        return RESOURCE_FORK;
                    }
                }
                throw new IllegalArgumentException("Unknown thread_kind " + threadKind + " for data thread_class of " + (Object)((Object)threadClass));
            }
            case FILENAME: {
                if (threadKind == 0) {
                    return FILENAME;
                }
                throw new IllegalArgumentException("Unknown thread_kind " + threadKind + " for filename thread_class of " + (Object)((Object)threadClass));
            }
        }
        throw new IllegalArgumentException("Unknown thread_class of " + (Object)((Object)threadClass));
    }
}

