/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.shrinkit;

import com.webcodepro.shrinkit.HeaderBlock;
import com.webcodepro.shrinkit.NuFileArchive;
import com.webcodepro.shrinkit.ThreadClass;
import com.webcodepro.shrinkit.ThreadFormat;
import com.webcodepro.shrinkit.ThreadKind;
import com.webcodepro.shrinkit.ThreadRecord;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;

public class NufxScan {
    private static File archiveWithSmallestCompressedFile;
    private static String smallestCompressedFilename;
    private static long sizeOfSmallestCompressedFile;

    public static void main(String[] args) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(NufxScan.class.getResourceAsStream("NufxScan.txt")));
        String line = r.readLine();
        while (line != null) {
            NufxScan.scanDirectory(line);
            line = r.readLine();
        }
    }

    private static void scanDirectory(String dirName) throws IOException {
        File[] files;
        File dir = new File(dirName);
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("'" + dirName + "' is not a directory");
        }
        for (File file : files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".shk") || name.toLowerCase().endsWith(".sdk");
            }
        })) {
            NufxScan.display(file);
        }
        if (sizeOfSmallestCompressedFile != 0L) {
            System.out.printf("\n\nSmallest compressed file:\n", new Object[0]);
            System.out.printf("Archive = %s\n", archiveWithSmallestCompressedFile.getAbsoluteFile());
            System.out.printf("Filename = %s\n", smallestCompressedFilename);
            System.out.printf("Size = %08x (%d)\n", sizeOfSmallestCompressedFile, sizeOfSmallestCompressedFile);
        }
    }

    private static void display(File archive) throws IOException {
        System.out.printf("Details for %s\n\n", archive.getAbsoluteFile());
        FileInputStream is = new FileInputStream(archive);
        if (is == null) {
            throw new IOException("Unable to locate '" + archive.getAbsoluteFile() + "'");
        }
        NuFileArchive a = new NuFileArchive(is);
        System.out.println("Ver# Threads  FSId FSIn Access   FileType ExtraTyp Stor Thread Formats..... OrigSize CompSize Filename");
        System.out.println("==== ======== ==== ==== ======== ======== ======== ==== =================== ======== ======== ==============================");
        for (HeaderBlock b : a.getHeaderBlocks()) {
            System.out.printf("%04x %08x %04x %04x %08x %08x %08x %04x ", b.getVersionNumber(), b.getTotalThreads(), b.getFileSysId(), b.getFileSysInfo(), b.getAccess(), b.getFileType(), b.getExtraType(), b.getStorageType());
            int threadsPrinted = 0;
            String filename = b.getFilename();
            long origSize = 0L;
            long compSize = 0L;
            boolean compressed = false;
            for (ThreadRecord r : b.getThreadRecords()) {
                ++threadsPrinted;
                System.out.printf("%04x ", r.getThreadFormat().getThreadFormat());
                compressed |= r.getThreadFormat() != ThreadFormat.UNCOMPRESSED;
                if (r.getThreadKind() == ThreadKind.FILENAME) {
                    filename = r.getText();
                }
                if (r.getThreadClass() != ThreadClass.DATA) continue;
                origSize += r.getThreadEof();
                compSize += r.getCompThreadEof();
            }
            while (threadsPrinted < 4) {
                System.out.printf("     ", new Object[0]);
                ++threadsPrinted;
            }
            System.out.printf("%08x %08x ", origSize, compSize);
            if (filename == null || filename.length() == 0) {
                filename = "<Unknown>";
            }
            System.out.println(filename);
            if (!compressed || sizeOfSmallestCompressedFile != 0L && compSize >= sizeOfSmallestCompressedFile) continue;
            sizeOfSmallestCompressedFile = compSize;
            archiveWithSmallestCompressedFile = archive;
            smallestCompressedFilename = filename;
        }
        System.out.println();
    }
}

