/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.shrinkit;

import com.webcodepro.shrinkit.HeaderBlock;
import com.webcodepro.shrinkit.MasterHeaderBlock;
import com.webcodepro.shrinkit.io.LittleEndianByteInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class NuFileArchive {
    private MasterHeaderBlock master;
    private List<HeaderBlock> headers;
    private long totalSize = 0L;
    public static final int NUFILE_ARCHIVE = 1;
    public static final int NUFX_ARCHIVE = 2;
    public static final int BXY_ARCHIVE = 3;

    public NuFileArchive(InputStream inputStream) throws IOException {
        LittleEndianByteInputStream bs = new LittleEndianByteInputStream(inputStream);
        this.master = new MasterHeaderBlock(bs);
        this.headers = new ArrayList<HeaderBlock>();
        int i = 0;
        while ((long)i < this.master.getTotalRecords()) {
            HeaderBlock header = new HeaderBlock(bs);
            header.readThreads(bs);
            this.headers.add(header);
            this.totalSize += header.getHeaderSize();
            ++i;
        }
    }

    public long getArchiveSize() {
        return this.totalSize;
    }

    public MasterHeaderBlock getMasterHeaderBlock() {
        return this.master;
    }

    public List<HeaderBlock> getHeaderBlocks() {
        return this.headers;
    }
}

