/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.util.readerwriter;

import com.webcodepro.applecommander.storage.os.rdos.RdosFileEntry;
import com.webcodepro.applecommander.util.readerwriter.FileEntryReader;
import java.util.Map;
import java.util.Optional;

public class RdosFileEntryReader
implements FileEntryReader {
    private static final Map<String, String> FILE_TYPES = Map.of("T", "TXT", "A", "BAS", "B", "BIN");
    private RdosFileEntry fileEntry;

    public RdosFileEntryReader(RdosFileEntry fileEntry) {
        this.fileEntry = fileEntry;
    }

    @Override
    public Optional<String> getFilename() {
        return Optional.ofNullable(this.fileEntry.getFilename());
    }

    @Override
    public Optional<Integer> getBinaryAddress() {
        return Optional.ofNullable(this.fileEntry.getAddress());
    }

    @Override
    public Optional<String> getProdosFiletype() {
        return Optional.ofNullable(FILE_TYPES.get(this.fileEntry.getFiletype()));
    }

    @Override
    public Optional<byte[]> getFileData() {
        return Optional.ofNullable(this.fileEntry.getFileData());
    }
}

