/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.UncheckedIOException;
import java.util.function.Function;

public class TranslatorStream
extends InputStream {
    private PushbackInputStream sourceStream;
    private Function<Integer, Integer> fn = i -> i;

    private TranslatorStream(InputStream sourceStream) {
        this.sourceStream = new PushbackInputStream(sourceStream);
    }

    @Override
    public int read() throws IOException {
        int data = this.sourceStream.read();
        if (data == -1) {
            return -1;
        }
        return this.fn.apply(data);
    }

    private int setHighBit(int value) {
        return value | 0x80;
    }

    private int clearHighBit(int value) {
        return value & 0x7F;
    }

    private int lfToCr(int value) {
        if (value == 13) {
            try {
                int nextValue = this.sourceStream.read();
                if (nextValue == 10) {
                    return 13;
                }
                if (nextValue != -1) {
                    this.sourceStream.unread(nextValue);
                }
                return value;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        return value == 10 ? 13 : value;
    }

    public static Builder builder(InputStream sourceStream) {
        return new Builder(sourceStream);
    }

    public static class Builder {
        private TranslatorStream stream;

        private Builder(InputStream sourceStream) {
            this.stream = new TranslatorStream(sourceStream);
        }

        private Builder fn(Function<Integer, Integer> andThen) {
            this.stream.fn = this.stream.fn.andThen(andThen);
            return this;
        }

        public Builder setHighBit() {
            return this.fn(x$0 -> this.stream.setHighBit((int)x$0));
        }

        public Builder clearHighBit() {
            return this.fn(x$0 -> this.stream.clearHighBit((int)x$0));
        }

        public Builder lfToCr() {
            return this.fn(x$0 -> this.stream.lfToCr((int)x$0));
        }

        public TranslatorStream get() {
            return this.stream;
        }
    }
}

