/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.util;

import com.webcodepro.applecommander.storage.Disk;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.os.prodos.ProdosFileEntry;
import com.webcodepro.applecommander.storage.os.prodos.ProdosFormatDisk;
import com.webcodepro.applecommander.storage.physical.ByteArrayImageLayout;
import com.webcodepro.applecommander.storage.physical.ProdosOrder;
import com.webcodepro.applecommander.util.Name;
import com.webcodepro.applecommander.util.TextBundle;
import com.webcodepro.shrinkit.HeaderBlock;
import com.webcodepro.shrinkit.NuFileArchive;
import com.webcodepro.shrinkit.ThreadRecord;
import com.webcodepro.shrinkit.io.LittleEndianByteInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ShrinkItUtilities {
    public static byte[] unpackSHKFile(String fileName) throws IOException {
        return ShrinkItUtilities.unpackSHKFile(fileName, 0);
    }

    public static byte[] unpackSHKFile(String fileName, int startBlocks) throws IOException {
        TextBundle textBundle = StorageBundle.getInstance();
        byte[] dmgBuffer = null;
        File file = new File(fileName);
        if (file.isDirectory() || !file.canRead()) {
            throw new IOException(textBundle.format("NotAFile", fileName, 1));
        }
        FileInputStream is = new FileInputStream(file);
        NuFileArchive a = new NuFileArchive((InputStream)is);
        int newDiskSize = Disk.sizeToFit(a.getArchiveSize());
        if (startBlocks > 0) {
            newDiskSize = startBlocks * 512;
        }
        ByteArrayImageLayout layout = new ByteArrayImageLayout(newDiskSize);
        ProdosOrder imageOrder = new ProdosOrder(layout);
        ProdosFormatDisk[] disks = ProdosFormatDisk.create(fileName, "APPLECOMMANDER", imageOrder);
        ProdosFormatDisk pdDisk = disks[0];
        for (HeaderBlock b : a.getHeaderBlocks()) {
            ProdosFileEntry newFile = null;
            ThreadRecord dataFork = null;
            ThreadRecord resourceFork = null;
            for (ThreadRecord r : b.getThreadRecords()) {
                try {
                    switch (r.getThreadKind()) {
                        case ASCII_TEXT: {
                            break;
                        }
                        case ALLOCATED_SPACE: {
                            break;
                        }
                        case APPLE_IIGS_ICON: {
                            break;
                        }
                        case CREATE_DIRECTORY: {
                            break;
                        }
                        case DATA_FORK: {
                            dataFork = r;
                            break;
                        }
                        case DISK_IMAGE: {
                            dmgBuffer = ShrinkItUtilities.readThread(r);
                            break;
                        }
                        case RESOURCE_FORK: {
                            resourceFork = r;
                            break;
                        }
                        case FILENAME: {
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    throw new IOException(ex.getMessage());
                }
            }
            try {
                Name name;
                if (dataFork == null && resourceFork == null || (newFile = (ProdosFileEntry)(name = new Name(b.getFilename())).createEntry(pdDisk)) == null) continue;
                if (resourceFork != null) {
                    newFile.setFileData(ShrinkItUtilities.readThread(dataFork), ShrinkItUtilities.readThread(resourceFork));
                    newFile.setStorageType(5);
                } else {
                    newFile.setFileData(ShrinkItUtilities.readThread(dataFork));
                }
                newFile.setFilename(b.getFinalFilename());
                newFile.setFiletype(b.getFileType());
                newFile.setAuxiliaryType((int)b.getExtraType());
                newFile.setCreationDate(b.getCreateWhen());
                newFile.setLastModificationDate(b.getModWhen());
                newFile = null;
            }
            catch (Exception ex) {
                throw new IOException(ex.getMessage());
            }
        }
        if (dmgBuffer != null) {
            return dmgBuffer;
        }
        return imageOrder.readBytes(0, newDiskSize);
    }

    public static byte[] readThread(ThreadRecord thread) throws IOException {
        byte[] buffer = null;
        if (thread != null) {
            thread.readThreadData(new LittleEndianByteInputStream(thread.getRawInputStream()));
            InputStream fis = thread.getInputStream();
            buffer = new byte[(int)thread.getThreadEof()];
            fis.read(buffer, 0, buffer.length);
            fis.close();
        }
        return buffer;
    }
}

