/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Range {
    private int first;
    private int last;

    public Range(int first, int last) {
        if (first < last) {
            this.first = first;
            this.last = last;
        } else {
            this.first = last;
            this.last = first;
        }
    }

    public int getFirst() {
        return this.first;
    }

    public int getLast() {
        return this.last;
    }

    public int size() {
        return this.last - this.first + 1;
    }

    public String toString() {
        if (this.first == this.last) {
            return String.format("%d", this.first);
        }
        return String.format("%d-%d", this.first, this.last);
    }

    public static List<Range> from(List<Integer> numbers) {
        ArrayList<Range> ranges = new ArrayList<Range>();
        Collections.sort(numbers);
        int first = -1;
        int last = -1;
        for (int number : numbers) {
            if (first == -1) {
                first = last = number;
                continue;
            }
            if (number == last + 1) {
                last = number;
                continue;
            }
            ranges.add(new Range(first, last));
            first = last = number;
        }
        if (first != -1) {
            ranges.add(new Range(first, last));
        }
        return ranges;
    }
}

