/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.util;

import com.webcodepro.applecommander.storage.DirectoryEntry;
import com.webcodepro.applecommander.storage.DiskException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.util.TextBundle;
import java.util.List;

public class Name {
    private static TextBundle textBundle = UiBundle.getInstance();
    private String fullName;
    private String name;
    private String[] path;

    public Name(String s) {
        this.fullName = s;
        if (s.startsWith("/")) {
            this.fullName = s.substring(1, s.length());
        }
        this.path = s.split("/");
        this.name = this.path[this.path.length - 1];
    }

    public FileEntry getEntry(FormattedDisk formattedDisk) throws DiskException {
        int i;
        List<FileEntry> files = formattedDisk.getFiles();
        FileEntry entry = null;
        for (i = 0; i < this.path.length - 1; ++i) {
            String dirName = this.path[i];
            for (int j = 0; j < files.size(); ++j) {
                entry = files.get(j);
                String entryName = entry.getFilename();
                if (!entry.isDirectory() || !dirName.equalsIgnoreCase(entryName)) continue;
                files = ((DirectoryEntry)((Object)entry)).getFiles();
            }
        }
        for (i = 0; i < files.size(); ++i) {
            entry = files.get(i);
            String entryName = entry.getFilename();
            if (entry.isDeleted() || !this.name.equalsIgnoreCase(entryName)) continue;
            return entry;
        }
        return null;
    }

    public FileEntry createEntry(FormattedDisk formattedDisk) throws DiskException {
        if (this.path.length == 1) {
            return formattedDisk.createFile();
        }
        List<FileEntry> files = formattedDisk.getFiles();
        DirectoryEntry dir = null;
        DirectoryEntry parentDir = null;
        for (int i = 0; i < this.path.length - 1; ++i) {
            String dirName = this.path[i];
            dir = null;
            for (int j = 0; j < files.size(); ++j) {
                FileEntry entry = files.get(j);
                String entryName = entry.getFilename();
                if (entry.isDeleted() || !entry.isDirectory() || !dirName.equalsIgnoreCase(entryName)) continue;
                parentDir = dir = (DirectoryEntry)((Object)entry);
                files = dir.getFiles();
            }
            if (dir != null) continue;
            parentDir = parentDir != null ? (dir = parentDir.createDirectory(dirName)) : (dir = formattedDisk.createDirectory(dirName));
        }
        if (dir != null) {
            return dir.createFile();
        }
        System.err.println(textBundle.format("CommandLineNoMatchMessage", this.fullName));
        return null;
    }
}

