/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.util;

import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.BusinessBASICToken;

public class BusinessBASICTokenizer {
    private static String[] tokens = new String[]{"END", "FOR", "NEXT", "INPUT", "OUTPUT", "DIM", "READ", "WRITE", "OPEN", "CLOSE", "*error*", "TEXT", "*error*", "BYE", "*error*", "*error*", "*error*", "*error*", "*error*", "WINDOW", "INVOKE", "PERFORM", "*error*", "*error*", "FRE", "HPOS", "VPOS", "ERRLIN", "ERR", "KBD", "EOF", "TIME$", "DATE$", "PREFIX$", "EXFN.", "EXFN%.", "OUTREC", "INDENT", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "POP", "HOME", "*error*", "SUB$(", "OFF", "TRACE", "NOTRACE", "NORMAL", "INVERSE", "SCALE(", "RESUME", "*error*", "LET", "GOTO", "IF", "RESTORE", "SWAP", "GOSUB", "RETURN", "REM", "STOP", "ON", "*error*", "LOAD", "SAVE", "DELETE", "RUN", "RENAME", "LOCK", "UNLOCK", "CREATE", "EXEC", "CHAIN", "*error*", "*error*", "*error*", "CATALOG", "*error*", "*error*", "DATA", "IMAGE", "CAT", "DEF", "*error*", "PRINT", "DEL", "ELSE", "CONT", "LIST", "CLEAR", "GET", "NEW", "TAB", "TO", "SPC(", "USING", "THEN", "*error*", "MOD", "STEP", "AND", "OR", "EXTENSION", " DIV", "*error*", "FN", "NOT", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "tf7", "TAB(", "TO", "SPC(", "USING", "THEN", "*error*", "MOD", "STEP", "AND", "OR", "EXTENSION", " DIV", "*error*", "FN", "NOT", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "AS", "SGN(", "INT(", "ABS(", "*error*", "TYP(", "REC(", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "PDL(", "BUTTON(", "SQR(", "RND(", "LOG(", "EXP(", "COS(", "SIN(", "TAN(", "ATN(", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "*error*", "STR$(", "HEX$(", "CHR$(", "LEN(", "VAL(", "ASC(", "TEN(", "*error*", "*error*", "CONV(", "CONV&(", "CONV$(", "CONV%(", "LEFT$(", "RIGHT$(", "MID$(", "INSTR(", "*error*", "*error*", "*error*", "*error*"};
    private byte[] fileData;
    private int offset = 2;
    private int nextAddress = -1;

    public BusinessBASICTokenizer(FileEntry fileEntry) {
        this(fileEntry.getFileData());
    }

    public BusinessBASICTokenizer(byte[] fileData) {
        this.fileData = fileData;
    }

    public boolean hasMoreTokens() {
        return this.offset < this.fileData.length;
    }

    public BusinessBASICToken getNextToken() {
        if (this.hasMoreTokens()) {
            byte byt;
            if (this.nextAddress == -1) {
                this.nextAddress = AppleUtil.getUnsignedByte(this.fileData, this.offset);
                ++this.offset;
                if (this.nextAddress == 0) {
                    this.offset = this.fileData.length;
                    return null;
                }
                int lineNumber = AppleUtil.getWordValue(this.fileData, this.offset);
                this.offset += 2;
                return new BusinessBASICToken(lineNumber);
            }
            if ((byt = this.fileData[this.offset++]) == 0) {
                this.nextAddress = -1;
                return this.getNextToken();
            }
            if ((byt & 0x80) != 0) {
                int token = AppleUtil.getUnsignedByte(byt) - 128;
                if (token == 127) {
                    byt = this.fileData[this.offset++];
                    token = AppleUtil.getUnsignedByte(byt);
                }
                if (token >= tokens.length) {
                    return new BusinessBASICToken(byt, "<UNKNOWN TOKEN>");
                }
                return new BusinessBASICToken(byt, tokens[token]);
            }
            if (byt == 58 || byt == 59 || byt == 44 || byt == 94 || byt == 43 || byt == 45 || byt == 42 || byt == 47) {
                return new BusinessBASICToken(new String(new byte[]{byt}));
            }
            StringBuffer string = new StringBuffer();
            while (true) {
                char ch;
                if ((ch = (char)byt) < ' ') {
                    string.append("<CTRL-");
                    string.append((char)(64 + ch));
                    string.append('>');
                } else {
                    string.append(ch);
                }
                byt = this.fileData[this.offset];
                if ((byt & 0x80) != 0 || byt == 0 || byt == 58 || byt == 44 || byt == 59) break;
                ++this.offset;
            }
            return new BusinessBASICToken(string.toString());
        }
        return null;
    }
}

