/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.physical;

import com.webcodepro.applecommander.storage.physical.ByteArrayImageLayout;

public abstract class ImageOrder {
    private ByteArrayImageLayout diskImageManager;

    public ImageOrder(ByteArrayImageLayout diskImageManager) {
        this.setDiskImageManager(diskImageManager);
    }

    public ByteArrayImageLayout getDiskImageManager() {
        return this.diskImageManager;
    }

    public int getPhysicalSize() {
        return this.diskImageManager.getPhysicalSize();
    }

    public void setDiskImageManager(ByteArrayImageLayout diskImageManager) {
        this.diskImageManager = diskImageManager;
    }

    public byte[] readBytes(int start, int length) {
        return this.diskImageManager.readBytes(start, length);
    }

    public void writeBytes(int start, byte[] bytes) {
        this.diskImageManager.writeBytes(start, bytes);
    }

    public int getBlocksOnDevice() {
        return this.getPhysicalSize() / 512;
    }

    public abstract String getName();

    public abstract byte[] readBlock(int var1);

    public abstract void writeBlock(int var1, byte[] var2);

    public abstract boolean isBlockDevice();

    public abstract boolean isTrackAndSectorDevice();

    public int getTracksPerDisk() {
        return this.getPhysicalSize() / (this.getSectorsPerTrack() * 256);
    }

    public int getSectorsPerTrack() {
        if (this.isSizeApprox(819200) || this.isSizeApprox(819264)) {
            return 32;
        }
        return 16;
    }

    public abstract byte[] readSector(int var1, int var2) throws IllegalArgumentException;

    public abstract void writeSector(int var1, int var2, byte[] var3) throws IllegalArgumentException;

    public boolean isSizeApprox(int value) {
        return this.getPhysicalSize() >= value && this.getPhysicalSize() <= value + 10;
    }

    public void format() {
        int size = this.diskImageManager.getPhysicalSize();
        this.diskImageManager.setDiskImage(new byte[size]);
    }

    public int getSectorsPerDisk() {
        return this.getTracksPerDisk() * this.getSectorsPerTrack();
    }
}

