/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.prodos;

import com.webcodepro.applecommander.storage.DirectoryEntry;
import com.webcodepro.applecommander.storage.DiskCorruptException;
import com.webcodepro.applecommander.storage.DiskException;
import com.webcodepro.applecommander.storage.DiskFullException;
import com.webcodepro.applecommander.storage.DiskGeometry;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.os.prodos.ProdosBlockAddress;
import com.webcodepro.applecommander.storage.os.prodos.ProdosCommonDirectoryHeader;
import com.webcodepro.applecommander.storage.os.prodos.ProdosCommonEntry;
import com.webcodepro.applecommander.storage.os.prodos.ProdosDirectoryEntry;
import com.webcodepro.applecommander.storage.os.prodos.ProdosDiskSizeDoesNotMatchException;
import com.webcodepro.applecommander.storage.os.prodos.ProdosFileEntry;
import com.webcodepro.applecommander.storage.os.prodos.ProdosSubdirectoryHeader;
import com.webcodepro.applecommander.storage.os.prodos.ProdosVolumeDirectoryHeader;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;

public class ProdosFormatDisk
extends FormattedDisk {
    private TextBundle textBundle = StorageBundle.getInstance();
    private static final int NEXT_BLOCK_POINTER = 2;
    private static final int PREV_BLOCK_POINTER = 0;
    private static final int VOLUME_DIRECTORY_BLOCK = 2;
    private static ProdosFileType[] fileTypes = new ProdosFileType[256];
    private static String[] filetypeStrings;
    private ProdosVolumeDirectoryHeader volumeHeader = new ProdosVolumeDirectoryHeader(this);

    public ProdosFormatDisk(String filename, ImageOrder imageOrder) {
        super(filename, imageOrder);
    }

    public static ProdosFormatDisk[] create(String filename, String diskName, ImageOrder imageOrder) {
        ProdosFormatDisk disk = new ProdosFormatDisk(filename, imageOrder);
        disk.format();
        disk.setDiskName(diskName);
        return new ProdosFormatDisk[]{disk};
    }

    @Override
    public String getFormat() {
        return this.textBundle.get("Prodos");
    }

    @Override
    public ProdosFileEntry createFile() throws DiskFullException {
        return this.createFile(this.volumeHeader);
    }

    public ProdosFileEntry createFile(ProdosCommonDirectoryHeader directory) throws DiskFullException {
        int blockNumber;
        int headerBlock = blockNumber = directory.getFileEntryBlock();
        while (blockNumber != 0) {
            byte[] block = this.readBlock(blockNumber);
            int offset = 4;
            while (offset + 39 < 512) {
                int value = AppleUtil.getUnsignedByte(block[offset]);
                if ((value & 0xF0) == 0) {
                    ProdosFileEntry fileEntry = new ProdosFileEntry(this, blockNumber, offset);
                    fileEntry.setKeyPointer(0);
                    fileEntry.setCreationDate(new Date());
                    fileEntry.setProdosVersion(0);
                    fileEntry.setMinimumProdosVersion(0);
                    fileEntry.setCanDestroy(true);
                    fileEntry.setCanRead(true);
                    fileEntry.setCanRename(true);
                    fileEntry.setCanWrite(true);
                    fileEntry.setSeedlingFile();
                    fileEntry.setHeaderPointer(headerBlock);
                    fileEntry.setFilename(this.textBundle.get("ProdosFormatDisk.Blank"));
                    directory.incrementFileCount();
                    return fileEntry;
                }
                offset += 39;
            }
            int nextBlockNumber = AppleUtil.getWordValue(block, 2);
            if (nextBlockNumber == 0 && directory instanceof ProdosSubdirectoryHeader) {
                byte[] volumeBitmap = this.readVolumeBitMap();
                nextBlockNumber = this.findFreeBlock(volumeBitmap);
                this.setBlockUsed(volumeBitmap, nextBlockNumber);
                this.writeVolumeBitMap(volumeBitmap);
                byte[] oldBlock = this.readBlock(blockNumber);
                AppleUtil.setWordValue(oldBlock, 2, nextBlockNumber);
                this.writeBlock(blockNumber, oldBlock);
                byte[] nextBlock = new byte[512];
                AppleUtil.setWordValue(nextBlock, 0, blockNumber);
                this.writeBlock(nextBlockNumber, nextBlock);
                ProdosSubdirectoryHeader header = (ProdosSubdirectoryHeader)directory;
                int blockCount = header.getProdosDirectoryEntry().getBlocksUsed();
                header.getProdosDirectoryEntry().setBlocksUsed(++blockCount);
                header.getProdosDirectoryEntry().setEofPosition(blockCount * 512);
            }
            blockNumber = nextBlockNumber;
        }
        if (directory instanceof ProdosSubdirectoryHeader) {
            throw new DiskFullException(this.textBundle.get("ProdosFormatDisk.UnableToAllocateSpaceError"), this.getFilename());
        }
        throw new DiskFullException(this.textBundle.get("ProdosFormatDisk.UnableToAllocateFileEntry"), this.getFilename());
    }

    @Override
    public List<FileEntry> getFiles() throws DiskException {
        return this.getFiles(2);
    }

    protected List<FileEntry> getFiles(int blockNumber) throws DiskException {
        ArrayList<FileEntry> files = new ArrayList<FileEntry>();
        HashSet<Integer> visits = new HashSet<Integer>();
        while (blockNumber != 0) {
            if (visits.contains(blockNumber)) {
                throw new DiskCorruptException(this.getFilename(), DiskCorruptException.Kind.RECURSIVE_DIRECTORY_STRUCTURE, new ProdosBlockAddress(blockNumber));
            }
            visits.add(blockNumber);
            byte[] block = this.readBlock(blockNumber);
            int offset = 4;
            while (offset + 39 < 512) {
                ProdosCommonEntry tester = new ProdosCommonEntry(this, blockNumber, offset);
                if (!(tester.isVolumeHeader() || tester.isSubdirectoryHeader() || tester.isEmpty())) {
                    ProdosFileEntry fileEntry = new ProdosFileEntry(this, blockNumber, offset);
                    if (fileEntry.isDirectory()) {
                        int keyPointer = fileEntry.getKeyPointer();
                        ProdosDirectoryEntry directoryEntry = new ProdosDirectoryEntry(this, blockNumber, offset, new ProdosSubdirectoryHeader(this, keyPointer));
                        files.add(directoryEntry);
                    } else {
                        files.add(fileEntry);
                    }
                }
                offset += 39;
            }
            blockNumber = AppleUtil.getWordValue(block, 2);
        }
        return files;
    }

    @Override
    public int getFreeSpace() {
        return this.getFreeBlocks() * 512;
    }

    public int getFreeBlocks() {
        int freeBlocks = 0;
        int blocksToProcess = (this.volumeHeader.getTotalBlocks() + 4095) / 4096;
        int blockNumber = this.volumeHeader.getBitMapPointer();
        for (int ix = 0; ix < blocksToProcess; ++ix) {
            byte[] block = this.readBlock(blockNumber + ix);
            for (int byt = 0; byt < block.length; ++byt) {
                freeBlocks += AppleUtil.getBitCount(block[byt]);
            }
        }
        return freeBlocks;
    }

    @Override
    public int getUsedSpace() {
        return this.getUsedBlocks() * 512;
    }

    public int getUsedBlocks() {
        return this.volumeHeader.getTotalBlocks() - this.getFreeBlocks();
    }

    @Override
    public boolean canCreateDirectories() {
        return true;
    }

    @Override
    public boolean canCreateFile() {
        return true;
    }

    @Override
    public String getDiskName() {
        return "/" + this.volumeHeader.getVolumeName() + "/";
    }

    @Override
    public void setDiskName(String volumeName) {
        this.volumeHeader.setVolumeName(volumeName);
    }

    @Override
    public int[] getBitmapDimensions() {
        return null;
    }

    @Override
    public int getBitmapLength() {
        return this.volumeHeader.getTotalBlocks();
    }

    @Override
    public FormattedDisk.DiskUsage getDiskUsage() {
        return new ProdosDiskUsage();
    }

    @Override
    public String[] getBitmapLabels() {
        return new String[]{this.textBundle.get("Block")};
    }

    @Override
    public List<FormattedDisk.DiskInformation> getDiskInformation() {
        List<FormattedDisk.DiskInformation> list = super.getDiskInformation();
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("TotalBlocks"), this.volumeHeader.getTotalBlocks()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("FreeBlocks"), this.getFreeBlocks()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("UsedBlocks"), this.getUsedBlocks()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("ProdosFormatDisk.VolumeAccess"), (this.volumeHeader.canDestroy() ? this.textBundle.get("Destroy") : "") + (this.volumeHeader.canRead() ? this.textBundle.get("Read") : "") + (this.volumeHeader.canRename() ? this.textBundle.get("Rename") : "") + (this.volumeHeader.canWrite() ? this.textBundle.get("Write") : "")));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("ProdosFormatDisk.BitmapBlockNumber"), this.volumeHeader.getBitMapPointer()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("ProdosFormatDisk.CreationDate"), this.volumeHeader.getCreationDate()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("ProdosFormatDisk.FileEntriesPerBlock"), this.volumeHeader.getEntriesPerBlock()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("ProdosFormatDisk.FileEntryLength"), this.volumeHeader.getEntryLength()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("ProdosFormatDisk.ActiveFilesInRootDirectory"), this.volumeHeader.getFileCount()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("ProdosFormatDisk.MinimumVersionProdos"), this.volumeHeader.getMinimumProdosVersion()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("ProdosFormatDisk.CreationVersionProdos"), this.volumeHeader.getProdosVersion()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("ProdosFormatDisk.VolumeName"), this.volumeHeader.getVolumeName()));
        return list;
    }

    @Override
    public List<FormattedDisk.FileColumnHeader> getFileColumnHeaders(int displayMode) {
        ArrayList<FormattedDisk.FileColumnHeader> list = new ArrayList<FormattedDisk.FileColumnHeader>();
        switch (displayMode) {
            case 2: {
                list.add(new FormattedDisk.FileColumnHeader(" ", 1, 2, "locked"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Name"), 15, 1, "name"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Filetype"), 8, 2, "type"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Blocks"), 3, 3, "blocks"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Modified"), 10, 2, "modified"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("ProdosFormatDisk.Created"), 10, 2, "created"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("ProdosFormatDisk.Length"), 10, 3, "size"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("ProdosFormatDisk.AuxType"), 8, 1, "auxType"));
                break;
            }
            case 3: {
                list.add(new FormattedDisk.FileColumnHeader(" ", 1, 2, "locked"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Name"), 15, 1, "name"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("DeletedQ"), 7, 2, "deleted"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("ProdosFormatDisk.Permissions"), 8, 1, "permissions"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Filetype"), 8, 2, "type"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("ProdosFormatDisk.DirectoryQ"), 9, 2, "directory"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Blocks"), 3, 3, "blocks"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Modified"), 16, 2, "modified"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("ProdosFormatDisk.Created"), 16, 2, "created"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("ProdosFormatDisk.Length"), 10, 3, "size"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("ProdosFormatDisk.AuxType"), 8, 1, "auxType"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("ProdosFormatDisk.DirectoryHeader"), 5, 3, "directory"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("ProdosFormatDisk.KeyBlock"), 5, 3, "keyBlock"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("ProdosFormatDisk.KeyType"), 8, 1, "keyType"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("ProdosFormatDisk.Changed"), 5, 2, "changed"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("ProdosFormatDisk.MinimumProdosVersion"), 2, 2, "minimumProdosVersion"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("ProdosFormatDisk.ProdosVersion"), 2, 2, "prodosVersion"));
                break;
            }
            default: {
                list.addAll(super.getFileColumnHeaders(displayMode));
            }
        }
        return list;
    }

    @Override
    public boolean supportsDeletedFiles() {
        return true;
    }

    @Override
    public boolean canReadFileData() {
        return true;
    }

    @Override
    public boolean canHaveDirectories() {
        return true;
    }

    @Override
    public boolean canWriteFileData() {
        return true;
    }

    @Override
    public boolean canDeleteFile() {
        return true;
    }

    @Override
    public byte[] getFileData(FileEntry fileEntry) {
        if (!(fileEntry instanceof ProdosFileEntry)) {
            throw new IllegalArgumentException(this.textBundle.get("ProdosFormatDisk.MustHaveEntry"));
        }
        ProdosFileEntry prodosEntry = (ProdosFileEntry)fileEntry;
        byte[] fileData = new byte[prodosEntry.getEofPosition()];
        if (prodosEntry.isSeedlingFile()) {
            byte[] blockData = this.readBlock(prodosEntry.getKeyPointer());
            System.arraycopy(blockData, 0, fileData, 0, prodosEntry.getEofPosition());
        } else if (prodosEntry.isSaplingFile()) {
            byte[] indexBlock = this.readBlock(prodosEntry.getKeyPointer());
            this.getIndexBlockData(fileData, indexBlock, 0);
        } else if (prodosEntry.isTreeFile()) {
            byte[] masterIndexBlock = this.readBlock(prodosEntry.getKeyPointer());
            int offset = 0;
            for (int i = 0; i < 256; ++i) {
                int blockNumber = AppleUtil.getWordValue(masterIndexBlock[i], masterIndexBlock[i + 256]);
                if (blockNumber <= 0) continue;
                byte[] indexBlock = this.readBlock(blockNumber);
                offset = this.getIndexBlockData(fileData, indexBlock, offset);
            }
        } else {
            throw new IllegalArgumentException(this.textBundle.get("ProdosFormatDisk.UnknownStorageType"));
        }
        return fileData;
    }

    protected void freeBlocks(ProdosFileEntry prodosFileEntry) {
        byte[] bitmap = this.readVolumeBitMap();
        int block = prodosFileEntry.getKeyPointer();
        if (block == 0) {
            return;
        }
        if (prodosFileEntry.isGEOSFile()) {
            this.setBlockFree(bitmap, prodosFileEntry.getAuxiliaryType());
        }
        this.setBlockFree(bitmap, block);
        if (prodosFileEntry.isSaplingFile()) {
            this.freeBlocksInIndex(bitmap, block, false);
        } else if (prodosFileEntry.isTreeFile()) {
            byte[] masterIndexBlock = this.readBlock(block);
            for (int i = 0; i < 256; ++i) {
                int indexBlockNumber;
                if (prodosFileEntry.isGEOSFile() && (!prodosFileEntry.isGEOSFile() || i >= 254) || (indexBlockNumber = AppleUtil.getWordValue(masterIndexBlock[i], masterIndexBlock[i + 256])) <= 0) continue;
                this.freeBlocksInIndex(bitmap, indexBlockNumber, prodosFileEntry.isGEOSFile());
            }
        }
        this.writeVolumeBitMap(bitmap);
    }

    private void freeBlocksInIndex(byte[] bitmap, int indexBlockNumber, boolean isGEOS) {
        this.setBlockFree(bitmap, indexBlockNumber);
        byte[] indexBlock = this.readBlock(indexBlockNumber);
        for (int i = 0; i < 256; ++i) {
            int blockNumber;
            if (isGEOS && (!isGEOS || i >= 254) || (blockNumber = AppleUtil.getWordValue(indexBlock[i], indexBlock[i + 256])) <= 0) continue;
            this.setBlockFree(bitmap, blockNumber);
        }
    }

    protected int getIndexBlockData(byte[] fileData, byte[] indexBlock, int offset) {
        for (int i = 0; i < 256; ++i) {
            int blockNumber = AppleUtil.getWordValue(indexBlock[i], indexBlock[i + 256]);
            byte[] blockData = this.readBlock(blockNumber);
            if (offset + blockData.length > fileData.length) {
                int bytesToCopy = fileData.length - offset;
                if (blockNumber != 0) {
                    System.arraycopy(blockData, 0, fileData, offset, bytesToCopy);
                }
                offset += bytesToCopy;
                break;
            }
            if (blockNumber != 0) {
                System.arraycopy(blockData, 0, fileData, offset, blockData.length);
            }
            offset += blockData.length;
        }
        return offset;
    }

    protected void setFileData(ProdosFileEntry fileEntry, byte[] fileData) throws DiskFullException {
        if (fileEntry.isGEOSFile()) {
            this.setGEOSFileData(fileEntry, fileData);
        } else {
            int numberOfBlocks;
            int numberOfDataBlocks = (fileData.length + 512 - 1) / 512;
            if (fileData.length == 0) {
                numberOfDataBlocks = 1;
            }
            if ((numberOfBlocks = numberOfDataBlocks) > 1) {
                numberOfBlocks += (numberOfDataBlocks - 1) / 256 + 1;
                if (numberOfDataBlocks > 256) {
                    ++numberOfBlocks;
                }
            }
            if (numberOfBlocks > this.getFreeBlocks() + fileEntry.getBlocksUsed()) {
                throw new DiskFullException(this.textBundle.format("ProdosFormatDisk.NotEnoughSpaceOnDiskError", numberOfBlocks, this.getFreeBlocks()), this.getFilename());
            }
            this.freeBlocks(fileEntry);
            byte[] bitmap = this.readVolumeBitMap();
            int blockNumber = fileEntry.getKeyPointer();
            if (blockNumber == 0) {
                blockNumber = this.findFreeBlock(bitmap);
            }
            int indexBlockNumber = 0;
            byte[] indexBlockData = null;
            int masterIndexBlockNumber = 0;
            byte[] masterIndexBlockData = new byte[512];
            int blockCount = 0;
            for (int offset = 0; offset < fileData.length || fileData.length == 0 && offset == 0; offset += 512) {
                byte high;
                byte low;
                int position;
                if (blockCount > 0) {
                    blockNumber = this.findFreeBlock(bitmap);
                }
                this.setBlockUsed(bitmap, blockNumber);
                ++blockCount;
                byte[] blockData = new byte[512];
                int length = Math.min(512, fileData.length - offset);
                System.arraycopy(fileData, offset, blockData, 0, length);
                this.writeBlock(blockNumber, blockData);
                if (numberOfDataBlocks <= 1) continue;
                if (offset > 0 && offset / 512 % 256 == 0) {
                    if (masterIndexBlockNumber == 0) {
                        masterIndexBlockNumber = this.findFreeBlock(bitmap);
                        this.setBlockUsed(bitmap, masterIndexBlockNumber);
                        ++blockCount;
                    }
                    this.writeBlock(indexBlockNumber, indexBlockData);
                    indexBlockData = null;
                    indexBlockNumber = 0;
                }
                if (indexBlockData == null) {
                    indexBlockNumber = this.findFreeBlock(bitmap);
                    indexBlockData = new byte[512];
                    this.setBlockUsed(bitmap, indexBlockNumber);
                    ++blockCount;
                    position = offset / 131072;
                    low = (byte)(indexBlockNumber % 256);
                    high = (byte)(indexBlockNumber / 256);
                    masterIndexBlockData[position] = low;
                    masterIndexBlockData[position + 256] = high;
                }
                position = offset / 512 % 256;
                low = (byte)(blockNumber % 256);
                high = (byte)(blockNumber / 256);
                indexBlockData[position] = low;
                indexBlockData[position + 256] = high;
            }
            if (numberOfDataBlocks == 1) {
                fileEntry.setKeyPointer(blockNumber);
                fileEntry.setSeedlingFile();
            } else if (numberOfDataBlocks <= 256) {
                this.writeBlock(indexBlockNumber, indexBlockData);
                fileEntry.setKeyPointer(indexBlockNumber);
                fileEntry.setSaplingFile();
            } else {
                this.writeBlock(indexBlockNumber, indexBlockData);
                this.writeBlock(masterIndexBlockNumber, masterIndexBlockData);
                fileEntry.setKeyPointer(masterIndexBlockNumber);
                fileEntry.setTreeFile();
            }
            fileEntry.setBlocksUsed(blockCount);
            fileEntry.setEofPosition(fileData.length);
            fileEntry.setLastModificationDate(new Date());
            this.writeVolumeBitMap(bitmap);
        }
    }

    protected void setFileData(ProdosFileEntry fileEntry, byte[] dataFork, byte[] resourceFork) throws DiskFullException {
        byte high;
        byte low;
        int position;
        int length;
        byte[] blockData;
        int offset;
        int numberOfDataBlocks;
        int numberOfBlocks;
        int dataLength = 0;
        int resourceLength = 0;
        if (dataFork != null) {
            dataLength = dataFork.length;
        }
        if (resourceFork != null) {
            resourceLength = resourceFork.length;
        }
        if ((numberOfBlocks = (numberOfDataBlocks = (dataLength + 512 - 1) / 512 + (resourceLength + 512 - 1) / 512)) > 1) {
            numberOfBlocks += (numberOfDataBlocks - 1) / 256 + 1;
            if (numberOfDataBlocks > 256) {
                ++numberOfBlocks;
            }
        }
        if (numberOfBlocks > this.getFreeBlocks() + fileEntry.getBlocksUsed()) {
            throw new DiskFullException(this.textBundle.format("ProdosFormatDisk.NotEnoughSpaceOnDiskError", numberOfBlocks, this.getFreeBlocks()), this.getFilename());
        }
        this.freeBlocks(fileEntry);
        byte[] bitmap = this.readVolumeBitMap();
        int blockNumber = fileEntry.getKeyPointer();
        if (blockNumber == 0) {
            blockNumber = this.findFreeBlock(bitmap);
        }
        int blockCount = 0;
        int extendedKeyBlockNumber = this.findFreeBlock(bitmap);
        this.setBlockUsed(bitmap, extendedKeyBlockNumber);
        byte[] extendedKeyBlockData = new byte[512];
        int indexBlockNumber = 0;
        byte[] indexBlockData = null;
        int masterIndexBlockNumber = 0;
        byte[] masterIndexBlockData = new byte[512];
        numberOfDataBlocks = (dataLength + 512 - 1) / 512;
        for (offset = 0; offset < dataLength; offset += 512) {
            blockNumber = this.findFreeBlock(bitmap);
            this.setBlockUsed(bitmap, blockNumber);
            ++blockCount;
            blockData = new byte[512];
            length = Math.min(512, dataLength - offset);
            System.arraycopy(dataFork, offset, blockData, 0, length);
            this.writeBlock(blockNumber, blockData);
            if (numberOfDataBlocks <= 1) continue;
            if (offset > 0 && offset / 512 % 256 == 0) {
                if (masterIndexBlockNumber == 0) {
                    masterIndexBlockNumber = this.findFreeBlock(bitmap);
                    this.setBlockUsed(bitmap, masterIndexBlockNumber);
                    ++blockCount;
                }
                this.writeBlock(indexBlockNumber, indexBlockData);
                indexBlockData = null;
                indexBlockNumber = 0;
            }
            if (indexBlockData == null) {
                indexBlockNumber = this.findFreeBlock(bitmap);
                indexBlockData = new byte[512];
                this.setBlockUsed(bitmap, indexBlockNumber);
                ++blockCount;
                position = offset / 131072;
                low = (byte)(indexBlockNumber % 256);
                high = (byte)(indexBlockNumber / 256);
                masterIndexBlockData[position] = low;
                masterIndexBlockData[position + 256] = high;
            }
            position = offset / 512 % 256;
            low = (byte)(blockNumber % 256);
            high = (byte)(blockNumber / 256);
            indexBlockData[position] = low;
            indexBlockData[position + 256] = high;
        }
        AppleUtil.setWordValue(extendedKeyBlockData, 3, numberOfDataBlocks);
        AppleUtil.set3ByteValue(extendedKeyBlockData, 5, dataLength);
        if (numberOfDataBlocks == 0 || numberOfDataBlocks == 1) {
            extendedKeyBlockData[0] = 1;
            AppleUtil.setWordValue(extendedKeyBlockData, 1, blockNumber);
        } else if (numberOfDataBlocks <= 256) {
            this.writeBlock(indexBlockNumber, indexBlockData);
            AppleUtil.setWordValue(extendedKeyBlockData, 1, indexBlockNumber);
            extendedKeyBlockData[0] = 2;
        } else {
            this.writeBlock(indexBlockNumber, indexBlockData);
            this.writeBlock(masterIndexBlockNumber, masterIndexBlockData);
            AppleUtil.setWordValue(extendedKeyBlockData, 1, masterIndexBlockNumber);
            extendedKeyBlockData[0] = 3;
        }
        ++blockCount;
        indexBlockNumber = 0;
        indexBlockData = null;
        masterIndexBlockNumber = 0;
        numberOfDataBlocks = (resourceLength + 512 - 1) / 512;
        for (offset = 0; offset < resourceLength; offset += 512) {
            if (blockCount > 0) {
                blockNumber = this.findFreeBlock(bitmap);
            }
            this.setBlockUsed(bitmap, blockNumber);
            ++blockCount;
            blockData = new byte[512];
            length = Math.min(512, resourceLength - offset);
            System.arraycopy(resourceFork, offset, blockData, 0, length);
            this.writeBlock(blockNumber, blockData);
            if (numberOfDataBlocks <= 1) continue;
            if (offset > 0 && offset / 512 % 256 == 0) {
                if (masterIndexBlockNumber == 0) {
                    masterIndexBlockNumber = this.findFreeBlock(bitmap);
                    this.setBlockUsed(bitmap, masterIndexBlockNumber);
                    ++blockCount;
                }
                this.writeBlock(indexBlockNumber, indexBlockData);
                indexBlockData = null;
                indexBlockNumber = 0;
            }
            if (indexBlockData == null) {
                indexBlockNumber = this.findFreeBlock(bitmap);
                indexBlockData = new byte[512];
                this.setBlockUsed(bitmap, indexBlockNumber);
                ++blockCount;
                position = offset / 131072;
                low = (byte)(indexBlockNumber % 256);
                high = (byte)(indexBlockNumber / 256);
                masterIndexBlockData[position] = low;
                masterIndexBlockData[position + 256] = high;
            }
            position = offset / 512 % 256;
            low = (byte)(blockNumber % 256);
            high = (byte)(blockNumber / 256);
            indexBlockData[position] = low;
            indexBlockData[position + 256] = high;
        }
        AppleUtil.setWordValue(extendedKeyBlockData, 259, numberOfDataBlocks);
        AppleUtil.set3ByteValue(extendedKeyBlockData, 261, resourceLength);
        if (numberOfDataBlocks == 0 || numberOfDataBlocks == 1) {
            extendedKeyBlockData[256] = 1;
            AppleUtil.setWordValue(extendedKeyBlockData, 257, blockNumber);
        } else if (numberOfDataBlocks <= 256) {
            this.writeBlock(indexBlockNumber, indexBlockData);
            AppleUtil.setWordValue(extendedKeyBlockData, 257, indexBlockNumber);
            extendedKeyBlockData[256] = 2;
        } else {
            this.writeBlock(indexBlockNumber, indexBlockData);
            this.writeBlock(masterIndexBlockNumber, masterIndexBlockData);
            AppleUtil.setWordValue(extendedKeyBlockData, 257, masterIndexBlockNumber);
            extendedKeyBlockData[256] = 3;
        }
        this.writeBlock(extendedKeyBlockNumber, extendedKeyBlockData);
        fileEntry.setKeyPointer(extendedKeyBlockNumber);
        fileEntry.setBlocksUsed(blockCount);
        fileEntry.setEofPosition(dataLength + resourceLength);
        fileEntry.setLastModificationDate(new Date());
        this.writeVolumeBitMap(bitmap);
    }

    protected void setGEOSFileData(ProdosFileEntry fileEntry, byte[] fileData) throws DiskFullException {
        int numberOfDataBlocks;
        int numberOfBlocks = numberOfDataBlocks = (fileData.length - 1) / 512;
        numberOfBlocks += (numberOfDataBlocks - 1) / 254 + 1;
        if (numberOfDataBlocks > 254) {
            ++numberOfBlocks;
        }
        if (numberOfBlocks > this.getFreeBlocks() + fileEntry.getBlocksUsed()) {
            throw new DiskFullException(this.textBundle.format("ProdosFormatDisk.NotEnoughSpaceOnDiskError", numberOfBlocks, this.getFreeBlocks()), this.getFilename());
        }
        this.freeBlocks(fileEntry);
        byte[] bitmap = this.readVolumeBitMap();
        int headerBlockNumber = this.findFreeBlock(bitmap);
        byte[] headerData = new byte[512];
        this.setBlockUsed(bitmap, headerBlockNumber);
        System.arraycopy(fileData, 0, headerData, 0, 512);
        this.writeBlock(headerBlockNumber, headerData);
        fileEntry.setAddress(headerBlockNumber);
        if (AppleUtil.getUnsignedByte(fileData[384]) >> 4 == 2) {
            this.setGEOSSaplingData(bitmap, fileEntry, fileData);
        } else {
            this.setGEOSTreeData(bitmap, fileEntry, fileData);
        }
        fileEntry.setGEOSMeta(headerData);
    }

    protected void setGEOSSaplingData(byte[] bitmap, ProdosFileEntry fileEntry, byte[] fileData) throws DiskFullException {
        int indexBlockNumber = this.findFreeBlock(bitmap);
        this.setBlockUsed(bitmap, indexBlockNumber);
        byte[] indexBlockData = new byte[512];
        int blockNumber = 0;
        int blockCount = 1;
        for (int offset = 512; offset < fileData.length; offset += 512) {
            blockNumber = this.findFreeBlock(bitmap);
            this.setBlockUsed(bitmap, blockNumber);
            ++blockCount;
            byte[] blockData = new byte[512];
            int length = Math.min(512, fileData.length - offset);
            System.arraycopy(fileData, offset, blockData, 0, length);
            this.writeBlock(blockNumber, blockData);
            int position = (offset - 512) / 512 % 256;
            byte low = (byte)(blockNumber % 256);
            byte high = (byte)(blockNumber / 256);
            indexBlockData[position] = low;
            indexBlockData[position + 256] = high;
        }
        indexBlockData[255] = (byte)((fileData.length - 512) % 256);
        indexBlockData[511] = (byte)((fileData.length - 512) / 256);
        this.writeBlock(indexBlockNumber, indexBlockData);
        fileEntry.setKeyPointer(indexBlockNumber);
        fileEntry.setSaplingFile();
        fileEntry.setBlocksUsed(blockCount);
        fileEntry.setEofPosition(fileData.length - 512);
        fileEntry.setLastModificationDate(new Date());
        this.writeVolumeBitMap(bitmap);
    }

    protected void setGEOSTreeData(byte[] bitmap, ProdosFileEntry fileEntry, byte[] fileData) throws DiskFullException {
        int masterIndexBlockNumber = this.findFreeBlock(bitmap);
        this.setBlockUsed(bitmap, masterIndexBlockNumber);
        byte[] masterIndexBlockData = new byte[512];
        int offset = 512;
        int blockCount = 2;
        int eofCount = 0;
        for (int masterIterator = 0; masterIterator < 254; ++masterIterator) {
            if (fileData[256 + masterIterator] != 255 && offset < fileData.length) {
                byte[] lengthData = new byte[512];
                System.arraycopy(fileData, offset, lengthData, 0, 512);
                offset += 512;
                int recordLength = AppleUtil.getUnsignedByte(lengthData[255]) + AppleUtil.getUnsignedByte(lengthData[511]) * 256;
                int indexBlockNumber = this.findFreeBlock(bitmap);
                this.setBlockUsed(bitmap, indexBlockNumber);
                ++blockCount;
                byte[] indexBlockData = new byte[512];
                int blockNumber = 0;
                int startingPoint = offset;
                while (offset < startingPoint + recordLength) {
                    blockNumber = this.findFreeBlock(bitmap);
                    this.setBlockUsed(bitmap, blockNumber);
                    ++blockCount;
                    byte[] blockData = new byte[512];
                    int length = Math.min(512, recordLength - offset + startingPoint);
                    System.arraycopy(fileData, offset, blockData, 0, length);
                    this.writeBlock(blockNumber, blockData);
                    eofCount += length;
                    int position = (offset - startingPoint) / 512 % 256;
                    byte low = (byte)(blockNumber % 256);
                    byte high = (byte)(blockNumber / 256);
                    indexBlockData[position] = low;
                    indexBlockData[position + 256] = high;
                    offset += 512;
                }
                indexBlockData[255] = (byte)(recordLength & 0xFF);
                indexBlockData[511] = (byte)((recordLength & 0xFF00) >> 8);
                indexBlockData[510] = (byte)((recordLength & 0xFF0000) >> 16);
                this.writeBlock(indexBlockNumber, indexBlockData);
                byte low = (byte)(indexBlockNumber % 256);
                byte high = (byte)(indexBlockNumber / 256);
                masterIndexBlockData[masterIterator] = low;
                masterIndexBlockData[masterIterator + 256] = high;
                continue;
            }
            if (fileData[256 + masterIterator] != 255) continue;
            masterIndexBlockData[masterIterator] = -1;
            masterIndexBlockData[masterIterator + 256] = -1;
        }
        masterIndexBlockData[255] = (byte)(eofCount & 0xFF);
        masterIndexBlockData[511] = (byte)((eofCount & 0xFF00) >> 8);
        masterIndexBlockData[510] = (byte)((eofCount & 0xFF0000) >> 16);
        this.writeBlock(masterIndexBlockNumber, masterIndexBlockData);
        fileEntry.setKeyPointer(masterIndexBlockNumber);
        fileEntry.setTreeFile();
        fileEntry.setBlocksUsed(blockCount);
        fileEntry.setEofPosition(eofCount);
        fileEntry.setLastModificationDate(new Date());
        this.writeVolumeBitMap(bitmap);
    }

    protected int findFreeBlock(byte[] volumeBitmap) throws DiskFullException {
        int blocksOnDisk = this.getBitmapLength();
        for (int block = 1; block < blocksOnDisk; ++block) {
            if (!this.isBlockFree(volumeBitmap, block)) continue;
            if ((block + 1) * 512 <= this.getPhysicalSize()) {
                return block;
            }
            throw new ProdosDiskSizeDoesNotMatchException(this.textBundle.get("ProdosFormatDisk.ProdosDiskSizeDoesNotMatchError"), this.getFilename());
        }
        throw new DiskFullException(this.textBundle.get("ProdosFormatDisk.NoFreeBlockAvailableError"), this.getFilename());
    }

    public byte[] readVolumeBitMap() {
        int volumeBitmapBlock = this.volumeHeader.getBitMapPointer();
        int volumeBitmapBlocks = this.volumeHeader.getTotalBlocks();
        int blocksToRead = volumeBitmapBlocks / 4096 + 1;
        byte[] data = new byte[blocksToRead * 512];
        for (int i = 0; i < blocksToRead; ++i) {
            System.arraycopy(this.readBlock(volumeBitmapBlock + i), 0, data, i * 512, 512);
        }
        return data;
    }

    public void writeVolumeBitMap(byte[] data) {
        int volumeBitmapBlock = this.volumeHeader.getBitMapPointer();
        int volumeBitmapBlocks = this.volumeHeader.getTotalBlocks();
        int blocksToWrite = volumeBitmapBlocks / 4096 + 1;
        if (data.length != blocksToWrite * 512) {
            throw new IllegalArgumentException(this.textBundle.get("ProdosFormatDisk.UnexpectedVolumeBitMapSizeError"));
        }
        byte[] dataBlock = new byte[512];
        for (int i = 0; i < blocksToWrite; ++i) {
            System.arraycopy(data, i * 512, dataBlock, 0, 512);
            this.writeBlock(volumeBitmapBlock + i, dataBlock);
        }
    }

    public boolean isBlockFree(byte[] data, int blockNumber) {
        int byt = blockNumber / 8;
        int bit = 7 - blockNumber % 8;
        boolean free = AppleUtil.isBitSet(data[byt], bit);
        return free;
    }

    public void setBlockFree(byte[] data, int blockNumber) {
        int byt = blockNumber / 8;
        int bit = 7 - blockNumber % 8;
        data[byt] = AppleUtil.setBit(data[byt], bit);
    }

    public boolean isBlockUsed(byte[] data, int blockNumber) {
        return !this.isBlockFree(data, blockNumber);
    }

    public void setBlockUsed(byte[] data, int blockNumber) {
        int byt = blockNumber / 8;
        int bit = 7 - blockNumber % 8;
        data[byt] = AppleUtil.clearBit(data[byt], bit);
    }

    @Override
    public void format() {
        this.getImageOrder().format();
        this.writeBootCode();
        String volumeName = this.volumeHeader.getVolumeName();
        int totalBlocks = this.getPhysicalSize() / 512;
        int usedBlocks = totalBlocks / 4096 + 7;
        byte[] data = new byte[512];
        for (int block = 2; block < 6; ++block) {
            int nextBlock = block < 5 ? block + 1 : 0;
            int prevBlock = block > 2 ? block - 1 : 0;
            AppleUtil.setWordValue(data, 0, prevBlock);
            AppleUtil.setWordValue(data, 2, nextBlock);
            this.writeBlock(block, data);
        }
        this.volumeHeader.setVolumeHeader();
        this.volumeHeader.setVolumeName(volumeName);
        this.volumeHeader.setCreationDate(new Date());
        this.volumeHeader.setProdosVersion(0);
        this.volumeHeader.setMinimumProdosVersion(0);
        this.volumeHeader.setHasChanged(true);
        this.volumeHeader.setCanDestroy(true);
        this.volumeHeader.setCanRead(true);
        this.volumeHeader.setCanRename(true);
        this.volumeHeader.setCanWrite(true);
        this.volumeHeader.setEntryLength();
        this.volumeHeader.setEntriesPerBlock();
        this.volumeHeader.setFileCount(0);
        this.volumeHeader.setBitMapPointer(6);
        this.volumeHeader.setTotalBlocks(totalBlocks);
        byte[] bitmap = this.readVolumeBitMap();
        for (int block = 0; block < totalBlocks; ++block) {
            if (block < usedBlocks) {
                this.setBlockUsed(bitmap, block);
                continue;
            }
            this.setBlockFree(bitmap, block);
        }
        this.writeVolumeBitMap(bitmap);
    }

    @Override
    public int getLogicalDiskNumber() {
        return 0;
    }

    @Override
    public String getSuggestedFilename(String filename) {
        StringBuffer newName = new StringBuffer();
        if (!Character.isLetter(filename.charAt(0))) {
            newName.append('A');
        }
        for (int i = 0; newName.length() < 15 && i < filename.length(); ++i) {
            char ch = filename.charAt(i);
            if (Character.isLetterOrDigit(ch)) {
                newName.append(ch);
                continue;
            }
            newName.append('.');
        }
        return newName.toString().toUpperCase().trim();
    }

    @Override
    public String getSuggestedFiletype(String filename) {
        String what;
        ProdosFileType type;
        String filetype = "BIN";
        int pos = filename.lastIndexOf(".");
        if (pos > 0 && (type = ProdosFormatDisk.findFileType(what = filename.substring(pos + 1))) != null) {
            filetype = type.getString();
        }
        return filetype;
    }

    public static String getFiletype(int filetype) {
        ProdosFileType prodostype = fileTypes[filetype];
        return prodostype.getString();
    }

    public byte getFiletype(String filetype) {
        ProdosFileType type = ProdosFormatDisk.findFileType(filetype);
        if (type != null) {
            return type.getType();
        }
        return 0;
    }

    public static ProdosFileType findFileType(String filetype) {
        for (int i = 0; i < fileTypes.length; ++i) {
            if (!filetype.equalsIgnoreCase(fileTypes[i].getString())) continue;
            return fileTypes[i];
        }
        return null;
    }

    @Override
    public String[] getFiletypes() {
        if (filetypeStrings == null) {
            filetypeStrings = new String[fileTypes.length];
            for (int i = 0; i < fileTypes.length; ++i) {
                ProdosFormatDisk.filetypeStrings[i] = fileTypes[i].getString();
            }
        }
        return filetypeStrings;
    }

    @Override
    public boolean needsAddress(String filetype) {
        ProdosFileType fileType = ProdosFormatDisk.findFileType(filetype);
        if (fileType != null) {
            return fileType.needsAddress();
        }
        return false;
    }

    public boolean canCompile(String filetype) {
        ProdosFileType fileType = ProdosFormatDisk.findFileType(filetype);
        if (fileType != null) {
            return fileType.canCompile();
        }
        return false;
    }

    @Override
    public boolean supportsDiskMap() {
        return true;
    }

    @Override
    public void changeImageOrder(ImageOrder imageOrder) {
        AppleUtil.changeImageOrderByBlock(this.getImageOrder(), imageOrder);
        this.setImageOrder(imageOrder);
    }

    @Override
    public void setFileData(FileEntry fileEntry, byte[] fileData) throws DiskFullException {
        this.setFileData((ProdosFileEntry)fileEntry, fileData);
    }

    protected ProdosVolumeDirectoryHeader getVolumeHeader() {
        return this.volumeHeader;
    }

    @Override
    public DirectoryEntry createDirectory(String name) throws DiskFullException {
        return this.createDirectory(this.getVolumeHeader(), name);
    }

    public DirectoryEntry createDirectory(ProdosCommonDirectoryHeader directory, String name) throws DiskFullException {
        int blockNumber = directory.getFileEntryBlock();
        while (blockNumber != 0) {
            byte[] volumeBitmap;
            byte[] block = this.readBlock(blockNumber);
            int entryNum = 1;
            int offset = 4;
            while (offset + 39 < 512) {
                int value = AppleUtil.getUnsignedByte(block[offset]);
                if ((value & 0xF0) == 0) {
                    volumeBitmap = this.readVolumeBitMap();
                    int newDirBlockNumber = this.findFreeBlock(volumeBitmap);
                    this.setBlockUsed(volumeBitmap, newDirBlockNumber);
                    byte[] cleanBlock = new byte[512];
                    for (int i = 0; i < 512; ++i) {
                        cleanBlock[i] = 0;
                    }
                    this.writeBlock(newDirBlockNumber, cleanBlock);
                    this.writeVolumeBitMap(volumeBitmap);
                    ProdosSubdirectoryHeader newHeader = new ProdosSubdirectoryHeader(this, newDirBlockNumber);
                    ProdosFileEntry subdirEntry = this.createFile(newHeader);
                    subdirEntry.setFilename(name);
                    newHeader.setHousekeeping();
                    newHeader.setCreationDate(new Date());
                    newHeader.setParentPointer(blockNumber);
                    newHeader.setParentEntry(entryNum);
                    newHeader.setParentEntryLength(39);
                    ProdosDirectoryEntry fileEntry = new ProdosDirectoryEntry(this, blockNumber, offset, newHeader);
                    fileEntry.setBlocksUsed(1);
                    fileEntry.setEofPosition(512);
                    fileEntry.setKeyPointer(newDirBlockNumber);
                    fileEntry.setCreationDate(new Date());
                    fileEntry.setLastModificationDate(new Date());
                    fileEntry.setProdosVersion(0);
                    fileEntry.setMinimumProdosVersion(0);
                    fileEntry.setCanDestroy(true);
                    fileEntry.setCanRead(true);
                    fileEntry.setCanRename(true);
                    fileEntry.setCanWrite(true);
                    fileEntry.setSubdirectory();
                    fileEntry.setHeaderPointer(blockNumber);
                    fileEntry.setFilename(name);
                    fileEntry.setFiletype(15L);
                    directory.incrementFileCount();
                    return fileEntry;
                }
                offset += 39;
                ++entryNum;
            }
            int nextBlockNumber = AppleUtil.getWordValue(block, 2);
            if (nextBlockNumber == 0 && directory instanceof ProdosSubdirectoryHeader) {
                volumeBitmap = this.readVolumeBitMap();
                nextBlockNumber = this.findFreeBlock(volumeBitmap);
                this.setBlockUsed(volumeBitmap, nextBlockNumber);
                this.writeVolumeBitMap(volumeBitmap);
                byte[] oldBlock = this.readBlock(blockNumber);
                AppleUtil.setWordValue(oldBlock, 2, nextBlockNumber);
                this.writeBlock(blockNumber, oldBlock);
                byte[] nextBlock = new byte[512];
                AppleUtil.setWordValue(nextBlock, 0, blockNumber);
                this.writeBlock(nextBlockNumber, nextBlock);
                ProdosSubdirectoryHeader header = (ProdosSubdirectoryHeader)directory;
                int blockCount = header.getProdosDirectoryEntry().getBlocksUsed();
                header.getProdosDirectoryEntry().setBlocksUsed(++blockCount);
                header.getProdosDirectoryEntry().setEofPosition(blockCount * 512);
            }
            blockNumber = nextBlockNumber;
        }
        if (directory instanceof ProdosSubdirectoryHeader) {
            throw new DiskFullException(this.textBundle.get("ProdosFormatDisk.UnableToAllocateSpaceError"), this.getFilename());
        }
        throw new DiskFullException(this.textBundle.get("ProdosFormatDisk.UnableToAllocateFileEntry"), this.getFilename());
    }

    @Override
    public DiskGeometry getDiskGeometry() {
        return DiskGeometry.BLOCK;
    }

    static {
        InputStream inputStream = ProdosFormatDisk.class.getResourceAsStream("ProdosFileTypes.properties");
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            for (int i = 0; i < 256; ++i) {
                String byt = AppleUtil.getFormattedByte(i).toLowerCase();
                Object string = (String)properties.get("filetype." + byt);
                if (string == null || ((String)string).length() == 0) {
                    string = "$" + byt.toUpperCase();
                }
                boolean addressRequired = Boolean.valueOf((String)properties.get("filetype." + byt + ".address"));
                boolean canCompile = Boolean.valueOf((String)properties.get("filetype." + byt + ".compile"));
                ProdosFormatDisk.fileTypes[i] = new ProdosFileType((byte)i, (String)string, addressRequired, canCompile);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class ProdosDiskUsage
    implements FormattedDisk.DiskUsage {
        private int location = -1;
        private transient byte[] data = null;

        private ProdosDiskUsage() {
        }

        @Override
        public boolean hasNext() {
            return this.location == -1 || this.location < ProdosFormatDisk.this.getVolumeHeader().getTotalBlocks() - 1;
        }

        @Override
        public void next() {
            ++this.location;
        }

        @Override
        public boolean isFree() {
            if (this.location == -1) {
                throw new IllegalArgumentException(StorageBundle.getInstance().get("ProdosFormatDisk.InvalidDimensionError"));
            }
            if (this.data == null) {
                this.data = ProdosFormatDisk.this.readVolumeBitMap();
            }
            return ProdosFormatDisk.this.isBlockFree(this.data, this.location);
        }

        @Override
        public boolean isUsed() {
            return !this.isFree();
        }
    }

    private static class ProdosFileType {
        private byte type;
        private String string;
        private boolean addressRequired;
        private boolean canCompile;

        public ProdosFileType(byte type, String string, boolean addressRequired, boolean canCompile) {
            this.type = type;
            this.string = string;
            this.addressRequired = addressRequired;
            this.canCompile = canCompile;
        }

        public byte getType() {
            return this.type;
        }

        public String getString() {
            return this.string;
        }

        public boolean needsAddress() {
            return this.addressRequired;
        }

        public boolean canCompile() {
            return this.canCompile;
        }
    }
}

